#include <klocale.h>
/****************************************************************************
** Form implementation generated from reading ui file './activemirrorcontrolbase.ui'
**
** Created: Fri Feb 6 20:23:07 2004
**      by:  The User Interface Compiler (uic)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/
#include "activemirrorcontrolbase.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlcdnumber.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/* 
 *  Constructs a ActiveMirrorControlBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ActiveMirrorControlBase::ActiveMirrorControlBase( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "ActiveMirrorControlBase" );
    resize( 638, 587 ); 
    setCaption( i18n( "AMC" ) );
    ActiveMirrorControlBaseLayout = new QGridLayout( this ); 
    ActiveMirrorControlBaseLayout->setSpacing( 6 );
    ActiveMirrorControlBaseLayout->setMargin( 11 );

    ActionGroup = new QButtonGroup( this, "ActionGroup" );
    ActionGroup->setTitle( i18n( "Actions" ) );
    ActionGroup->setColumnLayout(0, Qt::Vertical );
    ActionGroup->layout()->setSpacing( 0 );
    ActionGroup->layout()->setMargin( 0 );
    ActionGroupLayout = new QVBoxLayout( ActionGroup->layout() );
    ActionGroupLayout->setAlignment( Qt::AlignTop );
    ActionGroupLayout->setSpacing( 6 );
    ActionGroupLayout->setMargin( 11 );

    ModeButton = new QPushButton( ActionGroup, "ModeButton" );
    ModeButton->setText( i18n( "Go to user mode" ) );
    ModeButton->setToggleButton( FALSE );
    ModeButton->setToggleButton( FALSE );
    ActionGroupLayout->addWidget( ModeButton );

    ManualButton = new QPushButton( ActionGroup, "ManualButton" );
    ManualButton->setEnabled( FALSE );
    ManualButton->setText( i18n( "Move manualy" ) );
    ManualButton->setOn( FALSE );
    ManualButton->setOn( FALSE );
    ActionGroupLayout->addWidget( ManualButton );

    AdjustButton = new QPushButton( ActionGroup, "AdjustButton" );
    AdjustButton->setEnabled( FALSE );
    AdjustButton->setText( i18n( "Adjust" ) );
    ActionGroupLayout->addWidget( AdjustButton );

    LaserAdjustButton = new QPushButton( ActionGroup, "LaserAdjustButton" );
    LaserAdjustButton->setEnabled( FALSE );
    LaserAdjustButton->setText( i18n( "Laser Adjust" ) );
    ActionGroupLayout->addWidget( LaserAdjustButton );

    CenterAllButton = new QPushButton( ActionGroup, "CenterAllButton" );
    CenterAllButton->setEnabled( FALSE );
    CenterAllButton->setText( i18n( "Initialize AMC (Roque Lamp)" ) );
    ActionGroupLayout->addWidget( CenterAllButton );

    CalButton = new QPushButton( ActionGroup, "CalButton" );
    CalButton->setEnabled( FALSE );
    CalButton->setText( i18n( "Calibrate" ) );
    ActionGroupLayout->addWidget( CalButton );

    AutoFocusBox = new QCheckBox( ActionGroup, "AutoFocusBox" );
    AutoFocusBox->setText( i18n( "Autofocus" ) );
    ActionGroupLayout->addWidget( AutoFocusBox );

    ActiveMirrorControlBaseLayout->addWidget( ActionGroup, 0, 3 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    ActiveMirrorControlBaseLayout->addItem( spacer, 0, 2 );

    Frame3 = new QFrame( this, "Frame3" );
    Frame3->setFrameShape( QFrame::NoFrame );
    Frame3->setFrameShadow( QFrame::Raised );
    Frame3->setLineWidth( 0 );
    Frame3Layout = new QHBoxLayout( Frame3 ); 
    Frame3Layout->setSpacing( 6 );
    Frame3Layout->setMargin( 11 );

    LoopsSpinBox = new QSpinBox( Frame3, "LoopsSpinBox" );
    LoopsSpinBox->setEnabled( FALSE );
    LoopsSpinBox->setMaxValue( 500 );
    LoopsSpinBox->setMinValue( 50 );
    LoopsSpinBox->setLineStep( 50 );
    LoopsSpinBox->setValue( 50 );
    Frame3Layout->addWidget( LoopsSpinBox );

    ErrorTestButton = new QPushButton( Frame3, "ErrorTestButton" );
    ErrorTestButton->setEnabled( FALSE );
    ErrorTestButton->setText( i18n( "ErrorTest" ) );
    Frame3Layout->addWidget( ErrorTestButton );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Frame3Layout->addItem( spacer_2 );

    exitButton = new QPushButton( Frame3, "exitButton" );
    exitButton->setText( i18n( "&Exit" ) );
    exitButton->setDefault( FALSE );
    Frame3Layout->addWidget( exitButton );

    ActiveMirrorControlBaseLayout->addMultiCellWidget( Frame3, 2, 2, 0, 3 );

    InfoField = new QMultiLineEdit( this, "InfoField" );
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 237, 237, 237) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 110, 110) );
    cg.setColor( QColorGroup::Mid, QColor( 146, 146, 146) );
    cg.setColor( QColorGroup::Text, QColor( 255, 255, 0) );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, black );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 84, 112, 152) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 253, 253, 253) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 110, 110) );
    cg.setColor( QColorGroup::Mid, QColor( 146, 146, 146) );
    cg.setColor( QColorGroup::Text, QColor( 255, 255, 0) );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, black );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 84, 112, 152) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 253, 253, 253) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 110, 110) );
    cg.setColor( QColorGroup::Mid, QColor( 146, 146, 146) );
    cg.setColor( QColorGroup::Text, QColor( 255, 255, 0) );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, black );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 84, 112, 152) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
    InfoField->setPalette( pal );

    ActiveMirrorControlBaseLayout->addMultiCellWidget( InfoField, 1, 1, 0, 3 );

    PositionGroup = new QGroupBox( this, "PositionGroup" );
    PositionGroup->setTitle( i18n( "Pointing Info" ) );
    PositionGroup->setColumnLayout(0, Qt::Vertical );
    PositionGroup->layout()->setSpacing( 0 );
    PositionGroup->layout()->setMargin( 0 );
    PositionGroupLayout = new QGridLayout( PositionGroup->layout() );
    PositionGroupLayout->setAlignment( Qt::AlignTop );
    PositionGroupLayout->setSpacing( 6 );
    PositionGroupLayout->setMargin( 11 );

    TablePointing = new QGroupBox( PositionGroup, "TablePointing" );
    TablePointing->setEnabled( TRUE );
    TablePointing->setTitle( i18n( "LUT pointing" ) );
    TablePointing->setColumnLayout(0, Qt::Vertical );
    TablePointing->layout()->setSpacing( 0 );
    TablePointing->layout()->setMargin( 0 );
    TablePointingLayout = new QGridLayout( TablePointing->layout() );
    TablePointingLayout->setAlignment( Qt::AlignTop );
    TablePointingLayout->setSpacing( 6 );
    TablePointingLayout->setMargin( 11 );

    LUTAlt = new QLineEdit( TablePointing, "LUTAlt" );
    LUTAlt->setEnabled( FALSE );
    LUTAlt->setMaximumSize( QSize( 50, 32767 ) );
    LUTAlt->setMaxLength( 3 );
    LUTAlt->setEdited( FALSE );

    TablePointingLayout->addWidget( LUTAlt, 0, 1 );

    TextLabel3_2_2 = new QLabel( TablePointing, "TextLabel3_2_2" );
    TextLabel3_2_2->setText( i18n( "Az.:" ) );

    TablePointingLayout->addWidget( TextLabel3_2_2, 1, 0 );

    TextLabel3_3 = new QLabel( TablePointing, "TextLabel3_3" );
    TextLabel3_3->setText( i18n( "Zd.:" ) );

    TablePointingLayout->addWidget( TextLabel3_3, 0, 0 );

    LUTAz = new QLineEdit( TablePointing, "LUTAz" );
    LUTAz->setEnabled( FALSE );
    LUTAz->setMaximumSize( QSize( 50, 32767 ) );
    LUTAz->setMaxLength( 3 );
    LUTAz->setEdited( FALSE );

    TablePointingLayout->addWidget( LUTAz, 1, 1 );

    PositionGroupLayout->addWidget( TablePointing, 1, 0 );

    ActualPointing = new QGroupBox( PositionGroup, "ActualPointing" );
    ActualPointing->setTitle( i18n( "Actual pointing" ) );
    ActualPointing->setColumnLayout(0, Qt::Vertical );
    ActualPointing->layout()->setSpacing( 0 );
    ActualPointing->layout()->setMargin( 0 );
    ActualPointingLayout = new QGridLayout( ActualPointing->layout() );
    ActualPointingLayout->setAlignment( Qt::AlignTop );
    ActualPointingLayout->setSpacing( 6 );
    ActualPointingLayout->setMargin( 11 );

    ActualAlt = new QLineEdit( ActualPointing, "ActualAlt" );
    ActualAlt->setEnabled( TRUE );
    ActualAlt->setMaximumSize( QSize( 50, 32767 ) );
    ActualAlt->setMaxLength( 6 );
    ActualAlt->setEdited( FALSE );

    ActualPointingLayout->addWidget( ActualAlt, 0, 1 );

    TextLabel3_2 = new QLabel( ActualPointing, "TextLabel3_2" );
    TextLabel3_2->setText( i18n( "Az.:" ) );

    ActualPointingLayout->addWidget( TextLabel3_2, 1, 0 );

    TextLabel3 = new QLabel( ActualPointing, "TextLabel3" );
    TextLabel3->setText( i18n( "Zd.:" ) );

    ActualPointingLayout->addWidget( TextLabel3, 0, 0 );

    ActualAz = new QLineEdit( ActualPointing, "ActualAz" );
    ActualAz->setEnabled( TRUE );
    ActualAz->setMaximumSize( QSize( 50, 32767 ) );
    ActualAz->setMaxLength( 6 );
    ActualAz->setEdited( FALSE );

    ActualPointingLayout->addWidget( ActualAz, 1, 1 );

    PositionGroupLayout->addWidget( ActualPointing, 0, 0 );

    ActiveMirrorControlBaseLayout->addWidget( PositionGroup, 0, 1 );

    StateBox = new QGroupBox( this, "StateBox" );
    StateBox->setTitle( i18n( "State" ) );
    StateBox->setColumnLayout(0, Qt::Vertical );
    StateBox->layout()->setSpacing( 0 );
    StateBox->layout()->setMargin( 0 );
    StateBoxLayout = new QGridLayout( StateBox->layout() );
    StateBoxLayout->setAlignment( Qt::AlignTop );
    StateBoxLayout->setSpacing( 6 );
    StateBoxLayout->setMargin( 11 );

    TextLabel1 = new QLabel( StateBox, "TextLabel1" );
    QFont TextLabel1_font(  TextLabel1->font() );
    TextLabel1_font.setFamily( "adobe-helvetica" );
    TextLabel1_font.setPointSize( 14 );
    TextLabel1->setFont( TextLabel1_font ); 
    TextLabel1->setText( i18n( "State" ) );

    StateBoxLayout->addWidget( TextLabel1, 0, 0 );

    StateLabel = new QLabel( StateBox, "StateLabel" );
    StateLabel->setText( i18n( "AMC is not available" ) );

    StateBoxLayout->addMultiCellWidget( StateLabel, 1, 1, 0, 2 );

    TextLabel1_2 = new QLabel( StateBox, "TextLabel1_2" );
    QFont TextLabel1_2_font(  TextLabel1_2->font() );
    TextLabel1_2_font.setFamily( "adobe-helvetica" );
    TextLabel1_2_font.setPointSize( 14 );
    TextLabel1_2->setFont( TextLabel1_2_font ); 
    TextLabel1_2->setText( i18n( "Last Report" ) );

    StateBoxLayout->addWidget( TextLabel1_2, 2, 0 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    StateBoxLayout->addItem( spacer_3, 2, 1 );

    CommandTime = new QLabel( StateBox, "CommandTime" );
    CommandTime->setText( QString::null );

    StateBoxLayout->addWidget( CommandTime, 4, 2 );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    StateBoxLayout->addItem( spacer_4, 4, 1 );

    ReportLabel = new QLabel( StateBox, "ReportLabel" );
    ReportLabel->setText( i18n( "Startup" ) );

    StateBoxLayout->addMultiCellWidget( ReportLabel, 3, 3, 0, 2 );

    CommandLabel = new QLabel( StateBox, "CommandLabel" );
    CommandLabel->setText( i18n( "Global CC state" ) );

    StateBoxLayout->addWidget( CommandLabel, 5, 0 );
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    StateBoxLayout->addItem( spacer_5, 0, 1 );

    StateLCD = new QLCDNumber( StateBox, "StateLCD" );
    QFont StateLCD_font(  StateLCD->font() );
    StateLCD_font.setFamily( "adobe-helvetica" );
    StateLCD_font.setPointSize( 14 );
    StateLCD->setFont( StateLCD_font ); 
    StateLCD->setCursor( QCursor( 0 ) );
    StateLCD->setNumDigits( 1 );
    StateLCD->setSegmentStyle( QLCDNumber::Filled );
    StateLCD->setProperty( "intValue", 9 );

    StateBoxLayout->addWidget( StateLCD, 0, 2 );

    CCStateLCD = new QLCDNumber( StateBox, "CCStateLCD" );
    QFont CCStateLCD_font(  CCStateLCD->font() );
    CCStateLCD_font.setFamily( "adobe-helvetica" );
    CCStateLCD_font.setPointSize( 14 );
    CCStateLCD->setFont( CCStateLCD_font ); 
    CCStateLCD->setCursor( QCursor( 0 ) );
    CCStateLCD->setNumDigits( 1 );
    CCStateLCD->setSegmentStyle( QLCDNumber::Filled );
    CCStateLCD->setProperty( "intValue", 9 );

    StateBoxLayout->addWidget( CCStateLCD, 5, 2 );

    TextLabel1_2_2 = new QLabel( StateBox, "TextLabel1_2_2" );
    QFont TextLabel1_2_2_font(  TextLabel1_2_2->font() );
    TextLabel1_2_2_font.setFamily( "adobe-helvetica" );
    TextLabel1_2_2_font.setPointSize( 14 );
    TextLabel1_2_2->setFont( TextLabel1_2_2_font ); 
    TextLabel1_2_2->setText( i18n( "Last Command" ) );

    StateBoxLayout->addWidget( TextLabel1_2_2, 4, 0 );
    QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    StateBoxLayout->addItem( spacer_6, 5, 1 );

    ReportTime = new QLabel( StateBox, "ReportTime" );
    ReportTime->setText( QString::null );

    StateBoxLayout->addWidget( ReportTime, 2, 2 );

    ActiveMirrorControlBaseLayout->addWidget( StateBox, 0, 0 );

    // signals and slots connections
    connect( exitButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( ModeButton, SIGNAL( clicked() ), this, SLOT( userModeSlot() ) );
    connect( ManualButton, SIGNAL( clicked() ), this, SLOT( moveManuallySlot() ) );
    connect( CalButton, SIGNAL( clicked() ), this, SLOT( calibrateSlot() ) );
    connect( CenterAllButton, SIGNAL( clicked() ), this, SLOT( centerAllSlot() ) );
    connect( LaserAdjustButton, SIGNAL( clicked() ), this, SLOT( laserAdjustSlot() ) );
    connect( ErrorTestButton, SIGNAL( clicked() ), this, SLOT( errorTestSlot() ) );
    connect( AutoFocusBox, SIGNAL( toggled(bool) ), this, SLOT( autoFocusSlot( bool ) ) );
    connect( AdjustButton, SIGNAL( clicked() ), this, SLOT( adjustSlot() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ActiveMirrorControlBase::~ActiveMirrorControlBase()
{
    // no need to delete child widgets, Qt does it all for us
}

/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool ActiveMirrorControlBase::event( QEvent* ev )
{
    bool ret = QDialog::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont TextLabel1_font(  TextLabel1->font() );
	TextLabel1_font.setFamily( "adobe-helvetica" );
	TextLabel1_font.setPointSize( 14 );
	TextLabel1->setFont( TextLabel1_font ); 
	QFont TextLabel1_2_font(  TextLabel1_2->font() );
	TextLabel1_2_font.setFamily( "adobe-helvetica" );
	TextLabel1_2_font.setPointSize( 14 );
	TextLabel1_2->setFont( TextLabel1_2_font ); 
	QFont StateLCD_font(  StateLCD->font() );
	StateLCD_font.setFamily( "adobe-helvetica" );
	StateLCD_font.setPointSize( 14 );
	StateLCD->setFont( StateLCD_font ); 
	QFont CCStateLCD_font(  CCStateLCD->font() );
	CCStateLCD_font.setFamily( "adobe-helvetica" );
	CCStateLCD_font.setPointSize( 14 );
	CCStateLCD->setFont( CCStateLCD_font ); 
	QFont TextLabel1_2_2_font(  TextLabel1_2_2->font() );
	TextLabel1_2_2_font.setFamily( "adobe-helvetica" );
	TextLabel1_2_2_font.setPointSize( 14 );
	TextLabel1_2_2->setFont( TextLabel1_2_2_font ); 
    }
    return ret;
}

void ActiveMirrorControlBase::autoFocusSlot( bool )
{
    qWarning( "ActiveMirrorControlBase::autoFocusSlot( bool ): Not implemented yet!" );
}

void ActiveMirrorControlBase::calibrateSlot()
{
    qWarning( "ActiveMirrorControlBase::calibrateSlot(): Not implemented yet!" );
}

void ActiveMirrorControlBase::centerAllSlot()
{
    qWarning( "ActiveMirrorControlBase::centerAllSlot(): Not implemented yet!" );
}

void ActiveMirrorControlBase::errorTestSlot()
{
    qWarning( "ActiveMirrorControlBase::errorTestSlot(): Not implemented yet!" );
}

void ActiveMirrorControlBase::laserAdjustSlot()
{
    qWarning( "ActiveMirrorControlBase::laserAdjustSlot(): Not implemented yet!" );
}

void ActiveMirrorControlBase::moveManuallySlot()
{
    qWarning( "ActiveMirrorControlBase::moveManuallySlot(): Not implemented yet!" );
}

void ActiveMirrorControlBase::adjustSlot()
{
    qWarning( "ActiveMirrorControlBase::adjustSlot(): Not implemented yet!" );
}

void ActiveMirrorControlBase::userModeSlot()
{
    qWarning( "ActiveMirrorControlBase::userModeSlot(): Not implemented yet!" );
}

#include "activemirrorcontrolbase.moc"
