#ifndef MARS_MMcConfigRunHeader
#define MARS_MMcConfigRunHeader

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

#ifndef MARS_MGeomMirror
#include "MGeomMirror.h"
#endif
#ifndef MARS_MGeomPMT
#include "MGeomPMT.h"
#endif

class MGeomMirror;
class MGeomPMT;

class MMcConfigRunHeader : public MParContainer
{
private:
    // Mirror Information
    UShort_t      fNumMirrors;
    Float_t       fRadiusMirror;// [cm] Radius of a single mirror
    TClonesArray *fMirrors;     // FIXME: Change TClonesArray away from a pointer?

    // Magic Def Parameters
    Float_t fFocalDist;         // [cm] Focal distance
    Float_t fPointSpread;       // [cm] Point spread function, sigma in x and y on the camera
    Float_t fBlackSpot;         // [cm] Radius of black spot in the mirror center
    Float_t fCameraWidth;       // [cm] Radius on the camera plain 
                                // inside which the phe are kept.

    // QE Information
    UInt_t  fNumPMTs;
    TClonesArray  *fPMTs;

    // Light Guides Information
    TArrayF fIncidentTheta;    // [deg]
    TArrayF fLightGuidesFactor;// []

public:
    MMcConfigRunHeader(const char *name=NULL, const char *title=NULL);
    ~MMcConfigRunHeader() { delete fMirrors; delete fPMTs; }

    void SetMagicDef(Float_t radius, Float_t focal, Float_t point,
		     Float_t spot, Float_t camwidth);
    void SetLightGuides(const TArrayF &theta, const TArrayF &factor);

    UInt_t GetNumMirror() const { return fNumMirrors; }
    void   InitSizeMirror(UInt_t num) { fMirrors->Expand(num); }

    UInt_t GetNumPMTs() const { return fNumPMTs; }
    void   InitSizePMTs(UInt_t num) { fPMTs->Expand(num); }

    Float_t GetPointSpread() const { return fPointSpread; }
    void    SetPointSpread(Float_t x) { fPointSpread = x; }

    void   AddMirror(Int_t id)
    {
        new ((*fMirrors)[fNumMirrors++]) MGeomMirror(id);
    }

    void   AddPMT(Int_t id)
    {
        new ((*fPMTs)[fNumPMTs++]) MGeomPMT(id);
    }

    MGeomMirror &GetMirror(int i)  { return *(MGeomMirror*)(fMirrors->UncheckedAt(i)); }
    MGeomMirror &GetMirror(int i) const { return *(MGeomMirror*)(fMirrors->UncheckedAt(i)); }

    TClonesArray *GetMirrors() { return fMirrors; }

    MGeomPMT &GetPMT(int i)  { return *(MGeomPMT*)(fPMTs->UncheckedAt(i)); }
    MGeomPMT &GetPMT(int i) const { return *(MGeomPMT*)(fPMTs->UncheckedAt(i)); }

    ClassDef(MMcConfigRunHeader, 2)  // class for monte carlo configuration information
};

#endif

