
#ifndef PROCESSIO_H_SEEN
#define PROCESSIO_H_SEEN

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <limits.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>
#include <math.h>
#include <pthread.h>
#include <termios.h>
#include <fcntl.h>
#include <assert.h>
#include <dirent.h>
#include <sys/time.h>  
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/select.h>
#include <signal.h>

#include "Types.h"
#include "HVStatus.h"
#include "Log.h"
#include "HVConfig.h"
#include "HVCalib.h"
#include "Utilities.h"
#include "HV.h"

#include <iostream>
#include "../../fact_repos.svn/pixelmap/PixelMap.h"


class ProcessIO {

 private:
  
  time_t StartTime;

  char str[MAX_COM_SIZE];

  unsigned char wbuf[BUFFER_LENGTH];
  unsigned char rbuf[BUFFER_LENGTH];

  char bdata[16];

  PixelMap *pm;

 public:
  
  HVConfig*    config;
  HVCalib*     calib;
  Status*      status;
  Log*         log;

  pthread_mutex_t control_mutex;
  pthread_cond_t  control_cond;

  
  HV *hv;
  HVBoard *hvboard;
  

  ProcessIO(char *config_file);
  ~ProcessIO();

  void Scan();
  void PrintHelp();
  void PrintDateAndTime();
  void DoPrompt(char* str);
  void PrintMessage(char* str);
  void PrintMessageToLog(char *str);
  void PrintMessageO(char *Format, ...);
  int CommandControl();
  int NBoards(); 
  int InitializeHV();
  void UpdateStatus(int i, unsigned char* rbuf);
  void StartMonitor();
  void StopMonitor();
  void Monitor();
  void ResetActiveBoards();
  void ResetAllBoards();
  void ResetBoard(int i);
  int SaveHVSettings(char* filename);
  int IsBoard(int i);
  int GetBoardIdx(int board);

};

#endif
