#ifndef MARS_MPointingPos
#define MARS_MPointingPos

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MPointingPos : public MParContainer
{
private:
    Double_t fZd;  // [deg] Zenith distance (ZA)
    Double_t fAz;  // [deg] Azimuth

    Double_t fRa;  // [rad] Right ascension
    Double_t fHa;  // [rad] Hour angle
    Double_t fDec; // [rad] Declination

public:
    MPointingPos()
    {
        fName  = "MPointingPos";
        fTitle = "Container storing the (corrected) telescope pointing position";
    }

    void SetLocalPosition(Double_t zd, Double_t az) { fZd=zd; fAz=az; }
    void SetSkyPosition(Double_t ra, Double_t dec, Double_t ha=0) { fRa=ra; fDec=dec; fHa=ha; }

    Double_t GetZd() const  { return fZd; }
    Double_t GetAz() const  { return fAz; }

    Double_t GetRa() const  { return fRa; }
    Double_t GetDec() const { return fDec; }

    ClassDef(MPointingPos, 1) //Container storing the (corrected) telescope pointing position
};

#endif
