#ifndef MARS_MHFalseSource
#define MARS_MHFalseSource

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include <TH3.h>
#endif

class TH2D;

class MHillasSrc;
class MEnergyEst;
class MParList;
class MTime;
class MPointingPos;
class MObservatory;

class MHFalseSource : public MH
{
private:
    MTime        *fTime;        //! container to take the event time from
    MPointingPos *fPointPos;    //! container to take pointing position from
    MObservatory *fObservatory; //! conteiner to take observatory location from

    Float_t fMm2Deg;            // conversion factor for display in degrees
    Bool_t  fUseMmScale;        // which scale to use?

    Float_t fAlphaCut;          // Alpha cut

    Float_t fBgMean;            // Background mean

    TH3D    fHist;              // Alpha vs. x and y

    Int_t DistancetoPrimitive(Int_t px, Int_t py);
    void Modified();

    void ProjectOff(TH2D *h);
    void ProjectOn(TH2D *h);

public:
    MHFalseSource(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    void SetMmScale(Bool_t mmscale=kTRUE);
    void SetMm2Deg(Float_t mmdeg);

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void SetAlphaCut(Float_t alpha); //*MENU*
    void SetAlphaPlus5()  { SetAlphaCut(fAlphaCut+5); } //*MENU*
    void SetAlphaMinus5() { SetAlphaCut(fAlphaCut-5); } //*MENU*

    void SetBgMean(Float_t alpha); //*MENU*
    void SetBgMeanPlus5()  { SetBgMean(fBgMean+5); } //*MENU*
    void SetBgMeanMinus5() { SetBgMean(fBgMean-5); } //*MENU*

    //void FitSignificance(); //*MENU*

    void Paint(Option_t *opt="");
    void Draw(Option_t *option="");

    ClassDef(MHFalseSource, 1) //3D-histogram in alpha, x and y
};

#endif
