/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MHCalibrationChargeHiGainPix
//
//  Store the histogrammed Hi Gain summed FADC slices and the arrival times
//
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationChargeHiGainPix.h"

#include <TH1.h>
#include <TPad.h>
#include <TVirtualPad.h>
#include <TCanvas.h>

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

#include "MExtractedSignalCam.h"


ClassImp(MHCalibrationChargeHiGainPix);

using namespace std;

const Int_t   MHCalibrationChargeHiGainPix::fgChargeNbins     = 2000;
const Axis_t  MHCalibrationChargeHiGainPix::fgChargeFirst     = -0.5;
const Axis_t  MHCalibrationChargeHiGainPix::fgChargeLast      = 1999.5;
const Int_t   MHCalibrationChargeHiGainPix::fgAbsTimeNbins    = 20;
const Axis_t  MHCalibrationChargeHiGainPix::fgAbsTimeFirst    = -0.5;
const Axis_t  MHCalibrationChargeHiGainPix::fgAbsTimeLast     = 19.5;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
// Sets: 
// - the default number for fChargeNbins  (fgChargeNbins)
// - the default number for fChargeFirst  (fgChargeFirst)
// - the default number for fChargeLast   (fgChargeLast)
// - the default number for fAbsTimeNbins (fgAbstTimeNbins)
// - the default number for fAbsTimeFirst (fgAbsTimeFirst)
// - the default number for fAbsTimeLast  (fgAbsTimeLast)
//
// - the default name of the  fHGausHist ("HCalibrationChargeHiGainPix")
// - the default title of the fHGausHist ("Distribution of Summed Hi Gain FADC slices Pixel ")
//
// - the default name of the  fHAbsTime ("HAbsTimeHiGainPix")
// - the default title of the fHAbsTime ("Distribution of Absolute Arrival Times Hi Gain Pixel ")
//
MHCalibrationChargeHiGainPix::MHCalibrationChargeHiGainPix(const char *name, const char *title)
{

  fName  = name  ? name  : "MHCalibrationChargeHiGainPix";
  fTitle = title ? title : "Fill the FADC sums of the HiGainPix events and perform the fits Pixel ";
  
  SetChargeNbins();
  SetChargeFirst();
  SetChargeLast();
  
  SetAbsTimeNbins();
  SetAbsTimeFirst();
  SetAbsTimeLast();

  fHGausHist.SetName("HCalibrationChargeHiGainPix");
  fHGausHist.SetTitle("Distribution of Summed Hi Gain FADC slices Pixel ");  

  fHAbsTime.SetName("HAbsTimeHiGainPix");
  fHAbsTime.SetTitle("Distribution of Absolute Arrival Times Hi Gain Pixel ");  
}
