#ifndef MARS_MHCalibrationChargePix
#define MARS_MHCalibrationChargePix

#ifndef MARS_MHGausEvents
#include "MHGausEvents.h"
#endif

class TH1F;
class MHCalibrationChargePix : public MHGausEvents
{

private:

  static const Int_t   fgChargeNbins;        // Default for fChargeNBins  (now set to: 2000  )
  static const Axis_t  fgChargeFirst;        // Default for fChargeFirst  (now set to: -0.5  )
  static const Axis_t  fgChargeLast;         // Default for fChargeLast   (now set to: 1999.5)
  static const Int_t   fgAbsTimeNbins;       // Default for fAbsTimeNbins (now set to: 15    )
  static const Axis_t  fgAbsTimeFirst;       // Default for fAbsTimeFirst (now set to: -0.5  )
  static const Axis_t  fgAbsTimeLast;        // Default for fAbsTimeLast  (now set to: 14.5  )
  static const Float_t fgPickupLimit;        // Default for fPickupLimit  (now set to:  5.   )

protected:

  Int_t    fPixId;         // The pixel ID

  TH1F     fHAbsTime;      // Histogram containing the absolute arrival times 
                          
  Int_t    fChargeNbins;   // Number of  bins used for the fHGausHist
  Axis_t   fChargeFirst;   // Lower bound bin used for the fHGausHist
  Axis_t   fChargeLast;    // Upper bound bin used for the fHGausHist

  Int_t    fAbsTimeNbins;  // Number of  bins used for the fHAbsTime 
  Axis_t   fAbsTimeFirst;  // Lower bound bin used for the fHAbsTime
  Axis_t   fAbsTimeLast;   // Upper bound bin used for the fHAbsTime

  Float_t  fPickupLimit;   // Upper number of sigmas from the fitted mean above which events are considered as pickup

  Float_t  fSaturated;     // Number of events classified as saturated
  Float_t  fPickup;        // Number of events classified as pick-up

  Byte_t   fFlags;         // Bit-field for the flags
  enum     { kExcluded };  // Possible bits to be set

public:

  MHCalibrationChargePix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargePix() {}

  virtual void Clear(Option_t *o="");
  virtual void Reset();  
  virtual void Init();
  virtual void ChangeHistId(Int_t i);
  
  // Setters 
  virtual void SetChargeNbins(const Int_t  bins =fgChargeNbins)    { fChargeNbins = bins;   }
  virtual void SetChargeFirst(const Axis_t first=fgChargeFirst)    { fChargeFirst = first;  }
  virtual void SetChargeLast( const Axis_t last =fgChargeLast)     { fChargeLast  = last;   }
  
  virtual void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)  { fAbsTimeNbins = bins;  }
  virtual void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)  { fAbsTimeFirst = first; }
  virtual void SetAbsTimeLast( const Axis_t last =fgAbsTimeLast)   { fAbsTimeLast  = last;  }

  virtual void SetPickupLimit( const Float_t  lim =fgPickupLimit)  { fPickupLimit  = lim;   }

  void SetSaturated          ( const Float_t f    )                { fSaturated += f;      }
  void SetExcluded           ( const Bool_t b=kTRUE );

  // Getters
  TH1F *GetHAbsTime()                         { return &fHAbsTime;  }
  const TH1F *GetHAbsTime()             const { return &fHAbsTime;  }

  const Float_t  GetIntegral()          const;
  
  const Float_t  GetAbsTimeMean(  )     const;
  const Float_t  GetAbsTimeRms()        const;

  const Float_t  GetSaturated()         const { return fSaturated;   }
  const Float_t  GetPickup()            const { return fPickup;      }

  const Bool_t   IsExcluded()          const;

  // Fill histos
  Bool_t FillAbsTime(const Float_t t);

  // Fits
  Bool_t RepeatFit(const Option_t *option="RQ0");
  
  // Draws
  virtual void Draw(Option_t *opt="");

  // Miscelleaneous
  void CountPickup();

  ClassDef(MHCalibrationChargePix, 1)     // Base Histogram class for a Calibration Pixel
};

#endif
