#ifndef MARS_MHCalibrationRelTimePix
#define MARS_MHCalibrationRelTimePix

#ifndef MARS_MHGausEvents
#include "MHGausEvents.h"
#endif

class MHCalibrationRelTimePix : public MHGausEvents
{

private:

  static const Int_t   fgChargeNbins;      // Default for fChargeNBins  (now set to: 900   )
  static const Axis_t  fgChargeFirst;      // Default for fChargeFirst  (now set to: -13.5 )
  static const Axis_t  fgChargeLast;       // Default for fChargeLast   (now set to:  13.5 )

  Int_t   fChargeNbins;                   // Number of  bins used for the fHGausHist
  Axis_t  fChargeFirst;                   // Lower bound bin used for the fHGausHist
  Axis_t  fChargeLast;                    // Upper bound bin used for the fHGausHist

  Int_t fPixId;                           // The pixel ID

public:

  MHCalibrationRelTimePix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationRelTimePix() {}
  

  void Clear(Option_t *o="");
  void Reset();
  void Init();
  
  // Setters
  void SetChargeNbins(const Int_t  bins =fgChargeNbins)    { fChargeNbins = bins; }
  void SetChargeFirst(const Axis_t first=fgChargeFirst)    { fChargeFirst = first; }
  void SetChargeLast( const Axis_t last =fgChargeLast)     { fChargeLast  = last; }

  // Others
  void ChangeHistId(Int_t i);
  void Renorm(const Float_t slicewidth);
  
  ClassDef(MHCalibrationRelTimePix, 1)     // Histogram class for Relative Time Calibration pixel
};

#endif
