#ifndef MARS_MHCalibrationCam
#define MARS_MHCalibrationCam

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TText;
class TArrayI;
class TArrayF;
class MHGausEvents;
class MHCalibrationCam : public MH, public MCamEvent
{
  
protected:

  static const Int_t fgPulserFrequency;  // The default for fPulserFrequency (now set to: 500)
  Int_t   fPulserFrequency;             // Light pulser frequency
  
  TObjArray *fHiGainArray;              //-> Array of calibration pixels, one per pixel
  TObjArray *fLoGainArray;              //-> Array of calibration pixels, one per pixel
  TObjArray *fAverageHiGainAreas;       //-> Array of calibration pixels, one per pixel area
  TObjArray *fAverageLoGainAreas;       //-> Array of calibration pixels, one per pixel area
  TObjArray *fAverageHiGainSectors;     //-> Array of calibration pixels, one per camera sector
  TObjArray *fAverageLoGainSectors;     //-> Array of calibration pixels, one per camera sector

  TArrayI fAverageAreaNum;              // Number of pixels in average pixels per area
  TArrayI fAverageAreaSat;              // Number of saturated slices in average pixels per area
  TArrayF fAverageAreaSigma;            // Re-normalized sigmas in average pixels per area
  TArrayF fAverageAreaSigmaErr;         // Errors of Re-normalized sigmas in average pixels per area
  TArrayF fAverageAreaRelSigma;         // Re-normalized relative sigmas in average pixels per area
  TArrayF fAverageAreaRelSigmaErr;      // Errors of Re-normalized relative sigmas in average pixels per area
  TArrayI fAverageSectorNum;            // Number of pixels in average pixels per sector 

  void DrawAverageSigma(Bool_t sat, Bool_t inner,
                        Float_t sigma, Float_t sigmaerr,
                        Float_t relsigma, Float_t relsigmaerr) const; 
  
public:

  MHCalibrationCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationCam();

  void SetPulserFrequency(const Int_t f=fgPulserFrequency) { fPulserFrequency = f; }
  
  MHGausEvents  &operator[](UInt_t i);
  const MHGausEvents  &operator[](UInt_t i) const;
 
  MHGausEvents  &operator()(UInt_t i);
  const MHGausEvents  &operator()(UInt_t i)  const;
 
  MHGausEvents  &GetAverageHiGainArea(UInt_t i);
  const MHGausEvents   &GetAverageHiGainArea(UInt_t i)  const;

  MHGausEvents  &GetAverageLoGainArea(UInt_t i);
  const MHGausEvents   &GetAverageLoGainArea(UInt_t i)  const;

  MHGausEvents  &GetAverageHiGainSector(UInt_t i);
  const MHGausEvents   &GetAverageHiGainSector(UInt_t i)  const;

  MHGausEvents  &GetAverageLoGainSector(UInt_t i);
  const MHGausEvents   &GetAverageLoGainSector(UInt_t i)  const;

  // Clone
  TObject *Clone(const char *) const;
  
  // Draw
  virtual void Draw(const Option_t *opt);

  virtual Bool_t GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  virtual void   DrawPixelContent( Int_t num )  const;    

  ClassDef(MHCalibrationCam, 1)	// Base Histogram class for Calibration Camera
};

#endif









