#ifndef MARS_MHCalibrationChargeCam
#define MARS_MHCalibrationChargeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MRawEvtData;
class MGeomCam;
class MBadPixelsCam;
class MBadPixelsPix;
class MCalibrationChargeCam;
class MCalibrationChargePix;
class MHCalibrationChargePix;
class MHCalibrationChargeCam : public MHCalibrationCam
{
private:

  static const Int_t   fgAverageNbins;               // The default for fAverageNbins
  static const Float_t fgNumHiGainSaturationLimit;   // The default for fNumHiGainSaturationLimit
  static const Float_t fgNumLoGainSaturationLimit;   // The default for fNumLoGainSaturationLimit
  
  Int_t   fAverageNbins;              // Number of bins for the average histograms
  Float_t fNumHiGainSaturationLimit;  // Rel. amount sat. higain FADC slices until pixel is called saturated
  Float_t fNumLoGainSaturationLimit;  // Rel. amount sat. logain FADC slices until pixel is called saturated
  
  MCalibrationChargeCam  *fCam;       //!  Calibration Cam with the results
  MRawEvtData            *fRawEvt;    //!  Raw event data 
  MGeomCam               *fGeom;      //!  Camera geometry
  MBadPixelsCam          *fBadPixels; //!  Bad Pixels storage container

  void InitializeHiGainHists(MHCalibrationChargePix &hist, MBadPixelsPix &bad, const Int_t i);
  void InitializeLoGainHists(MHCalibrationChargePix &hist, MBadPixelsPix &bad, const Int_t i);  
  
  void FinalizeHiGainHists(MHCalibrationChargePix &hist, MCalibrationChargePix &pix, MBadPixelsPix &bad);
  void FinalizeLoGainHists(MHCalibrationChargePix &hist, MCalibrationChargePix &pix, MBadPixelsPix &bad);

 public:

  MHCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeCam() {}
  

  void SetAverageNbins(    const Int_t bins=fgAverageNbins  )          { fAverageNbins = bins; }
  void SetNumLoGainSaturationLimit( const Float_t lim=fgNumLoGainSaturationLimit) { fNumLoGainSaturationLimit = lim; }
  void SetNumHiGainSaturationLimit( const Float_t lim=fgNumHiGainSaturationLimit) { fNumHiGainSaturationLimit = lim; }
  
  Float_t GetNumHiGainSaturationLimit()      const  { return fNumHiGainSaturationLimit; }
  Float_t GetNumLoGainSaturationLimit()      const  { return fNumLoGainSaturationLimit; }

  Bool_t SetupFill(const MParList *pList);
  Bool_t ReInit   (      MParList *pList);
  Bool_t Fill     (const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize ( );

  Bool_t GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void   DrawPixelContent( Int_t num )  const;    

  ClassDef(MHCalibrationChargeCam, 1)	// Histogram class for camera calibration 
};

#endif









