#ifndef MARS_MCalibrationPix
#define MARS_MCalibrationPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MBadPixelsPix;
class MCalibrationPix : public MParContainer
{
protected:

  Int_t   fPixId;       // the pixel Id

  UInt_t  fFlags;       // Flag for the set bits
 
  Float_t fHiGainMean;        // The mean reduced charge after the fit
  Float_t fHiGainMeanVar;     // The error of reduced mean charge after the fit
  Float_t fHiGainSigma;       // The sigma of the mean charge after the fit
  Float_t fHiGainSigmaVar;    // The error of the sigma of the mean charge after the fit
  Float_t fHiGainProb;        // The probability of the fit function 
  Float_t fHiGainNumPickup;   // The number of pickup events in the high-gain
  
  Float_t fLoGainMean;        // The mean reduced charge after the fit
  Float_t fLoGainMeanVar;     // The error of reduced mean charge after the fit
  Float_t fLoGainSigma;       // The sigma of the mean charge after the fit
  Float_t fLoGainSigmaVar;    // The error of the sigma of the mean charge after the fit
  Float_t fLoGainProb;        // The probability of the fit function 
  Float_t fLoGainNumPickup;   // The number of pickup events in the low-gain

  enum  { kHiGainSaturation, kExcluded };
  
public:

  MCalibrationPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationPix() {}
  
  virtual void Clear(Option_t *o="");

  // Setter
  void SetPixId( const Int_t i )   { fPixId = i; }

  void SetHiGainMean      ( const Float_t f ) { fHiGainMean      = f;   }
  void SetHiGainMeanErr   ( const Float_t f ) { fHiGainMeanVar   = f*f; }
  void SetHiGainProb      ( const Float_t f ) { fHiGainProb      = f;   }
  void SetHiGainSigma     ( const Float_t f ) { fHiGainSigma     = f;   }
  void SetHiGainSigmaErr  ( const Float_t f ) { fHiGainSigmaVar  = f*f; }
  void SetHiGainNumPickup ( const Float_t f ) { fHiGainNumPickup = f;   }

  void SetLoGainMean      ( const Float_t f ) { fLoGainMean      = f;   }
  void SetLoGainMeanErr   ( const Float_t f ) { fLoGainMeanVar   = f*f; }
  void SetLoGainProb      ( const Float_t f ) { fLoGainProb      = f;   }
  void SetLoGainSigma     ( const Float_t f ) { fLoGainSigma     = f;   }
  void SetLoGainSigmaErr  ( const Float_t f ) { fLoGainSigmaVar  = f*f; }
  void SetLoGainNumPickup ( const Float_t f ) { fLoGainNumPickup = f;   }

  void SetMean       ( const Float_t f ) { IsHiGainSaturation() ? fLoGainMean = f       : fHiGainMean = f      ; }
  void SetMeanErr    ( const Float_t f ) { IsHiGainSaturation() ? fLoGainMeanVar = f*f  : fHiGainMeanVar = f*f ; }
  void SetProb       ( const Float_t f ) { IsHiGainSaturation() ? fLoGainProb = f       : fHiGainProb = f      ; }
  void SetSigma      ( const Float_t f ) { IsHiGainSaturation() ? fLoGainSigma = f      : fHiGainSigma = f     ; }
  void SetSigmaErr   ( const Float_t f ) { IsHiGainSaturation() ? fLoGainSigmaVar = f*f : fHiGainSigmaVar = f*f; }
  void SetNumPickup  ( const Float_t f ) { IsHiGainSaturation() ? fLoGainNumPickup = f  : fHiGainNumPickup = f ; }
  
  void SetHiGainSaturation( const Bool_t  b = kTRUE );
  void SetExcluded        ( const Bool_t  b = kTRUE );

  // Getters
  Float_t GetHiGainMean     () const { return fHiGainMean   ;   }
  Float_t GetHiGainMeanErr  () const;
  Float_t GetHiGainProb     () const { return fHiGainProb   ;   }
  Float_t GetHiGainSigma    () const { return fHiGainSigma  ;   }
  Float_t GetHiGainSigmaErr () const;
  Float_t GetHiGainNumPickup() const { return fHiGainNumPickup; }

  virtual Float_t GetLoGainMean     () const { return fLoGainMean   ;   }
  virtual Float_t GetLoGainMeanErr  () const;
  virtual Float_t GetLoGainProb     () const { return fLoGainProb   ;   }
  virtual Float_t GetLoGainSigma    () const { return fLoGainSigma  ;   }
  virtual Float_t GetLoGainSigmaErr () const;
  virtual Float_t GetLoGainNumPickup() const { return fLoGainNumPickup; }

  Float_t GetMean       () const { return IsHiGainSaturation() ? GetLoGainMean()      : GetHiGainMean()     ; }
  Float_t GetMeanErr    () const { return IsHiGainSaturation() ? GetLoGainMeanErr()   : GetHiGainMeanErr()  ; }
  Float_t GetProb       () const { return IsHiGainSaturation() ? GetLoGainProb()      : GetHiGainProb()     ; }
  Float_t GetSigma      () const { return IsHiGainSaturation() ? GetLoGainSigma()     : GetHiGainSigma()    ; }
  Float_t GetSigmaErr   () const { return IsHiGainSaturation() ? GetLoGainSigmaErr()  : GetHiGainSigmaErr() ; }
  Float_t GetNumPickup  () const { return IsHiGainSaturation() ? GetLoGainNumPickup() : GetHiGainNumPickup(); }

  Int_t   GetPixId      () const { return fPixId ;  }

  Bool_t  IsExcluded()         const;
  Bool_t  IsHiGainSaturation() const;

  ClassDef(MCalibrationPix, 1)	// Container for Calibration of one pixel
};

#endif

