#ifndef MARS_MCalibrationRelTimeCam
#define MARS_MCalibrationRelTimeCam

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class MCalibrationRelTimePix;
class MBadPixelsPix;
class MBadPixelsCam;
class MCalibrationRelTimeCam : public MCalibrationCam
{
private:
  
  enum  { kValid };

public:

  MCalibrationRelTimeCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationRelTimeCam() {}
  
  
  void Clear(    Option_t *o="" );

  // Setters   
  void SetValid(    const Bool_t b = kTRUE );

  Bool_t  GetConversion(    Int_t ipx, Float_t &mean, Float_t &err, Float_t &sigma );

  Bool_t IsValid()   const;

  // Prints
  void Print(Option_t *o="") const;
  
  // Draws
  void DrawPixelContent(Int_t num) const;    
  
  // Others
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;

  ClassDef(MCalibrationRelTimeCam, 1)	// Container for calibration of the camera
};

#endif
