#ifndef MARS_MHCalibrationChargeLoGainPix
#define MARS_MHCalibrationChargeLoGainPix


#ifndef MARS_MHCalibrationChargePix
#include "MHCalibrationChargePix.h"
#endif

class MHCalibrationChargeLoGainPix : public MHCalibrationChargePix
{
private:

  static const Int_t   fgChargeNbins;      // Default for MHGausEvents::fNbins (now set to: 200   )
  static const Axis_t  fgChargeFirst;      // Default for MHGausEvents::fFirst (now set to: -0.5  )
  static const Axis_t  fgChargeLast;       // Default for MHGausEvents::fLast  (now set to: 199.5 )
  static const Int_t   fgAbsTimeNbins;     // Default for fAbsTimeNbins        (now set to: 15    )
  static const Axis_t  fgAbsTimeFirst;     // Default for fAbsTimeFirst        (now set to: -0.5  )
  static const Axis_t  fgAbsTimeLast;      // Default for fAbsTimeLast         (now set to: 14.5  )

public:

  MHCalibrationChargeLoGainPix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeLoGainPix(){}

  // Setters
  void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)        { fAbsTimeNbins = bins;    }
  void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)        { fAbsTimeFirst = first;   }
  void SetAbsTimeLast (const Axis_t last =fgAbsTimeLast)         { fAbsTimeLast  = last;    }

  ClassDef(MHCalibrationChargeLoGainPix, 1)  // Histogram class for Low Gain Part of Calibration Pixel
};

#endif








