#ifndef MARS_MHCalibrationChargePix
#define MARS_MHCalibrationChargePix

#ifndef MARS_MHGausEvents
#include "MHGausEvents.h"
#endif

class TH1F;
class MHCalibrationChargePix : public MHGausEvents
{

private:

  static const Int_t   fgChargeNbins;        // Default for MHGausEvents::fNBins (now set to: 2000  )
  static const Axis_t  fgChargeFirst;        // Default for MHGausEvents::fFirst (now set to: -0.5  )
  static const Axis_t  fgChargeLast;         // Default for MHGausEvents::fLast  (now set to: 1999.5)
  static const Int_t   fgAbsTimeNbins;       // Default for fAbsTimeNbins        (now set to: 15    )
  static const Axis_t  fgAbsTimeFirst;       // Default for fAbsTimeFirst        (now set to: -0.5  )
  static const Axis_t  fgAbsTimeLast;        // Default for fAbsTimeLast         (now set to: 14.5  )

protected:

  TH1F     fHAbsTime;      // Histogram containing the absolute arrival times 
                          
  Int_t    fAbsTimeNbins;  // Number of  bins used for the fHAbsTime 
  Axis_t   fAbsTimeFirst;  // Lower bound bin used for the fHAbsTime
  Axis_t   fAbsTimeLast;   // Upper bound bin used for the fHAbsTime

  Float_t  fSaturated;     // Number of events classified as saturated

public:

  MHCalibrationChargePix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargePix() {}

  virtual void Clear(Option_t *o="");
  virtual void Reset();  
  virtual void InitBins();
  
  // Setters 
  virtual void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)  { fAbsTimeNbins = bins;  }
  virtual void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)  { fAbsTimeFirst = first; }
  virtual void SetAbsTimeLast( const Axis_t last =fgAbsTimeLast)   { fAbsTimeLast  = last;  }

  void SetSaturated          ( const Float_t f    )                { fSaturated += f;      }

  // Getters
  TH1F *GetHAbsTime()                         { return &fHAbsTime;  }
  const TH1F *GetHAbsTime()             const { return &fHAbsTime;  }

  const Float_t  GetAbsTimeMean(  )     const;
  const Float_t  GetAbsTimeRms()        const;
  const Float_t  GetIntegral()          const;
  const Float_t  GetSaturated()         const { return fSaturated;   }

  // Fill histos
  Bool_t FillAbsTime(const Float_t t);

  // Draws
  virtual void Draw(Option_t *opt="");

  // Miscelleaneous
  void ChangeHistId(Int_t id);
  
  ClassDef(MHCalibrationChargePix, 1)     // Base Histogram class for a Charge Calibration Pixel
};

#endif
