/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MHCalibrationChargeLoGainPix
//
//  Store the histogrammed Hi Gain summed FADC slices and the arrival times
//
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationChargeLoGainPix.h"

#include <TH1.h>
#include <TPad.h>
#include <TVirtualPad.h>
#include <TCanvas.h>

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

#include "MExtractedSignalCam.h"


ClassImp(MHCalibrationChargeLoGainPix);

using namespace std;

const Int_t   MHCalibrationChargeLoGainPix::fgChargeNbins     = 200;
const Axis_t  MHCalibrationChargeLoGainPix::fgChargeFirst     = -0.5;
const Axis_t  MHCalibrationChargeLoGainPix::fgChargeLast      = 199.5;
const Int_t   MHCalibrationChargeLoGainPix::fgAbsTimeNbins    = 15;
const Axis_t  MHCalibrationChargeLoGainPix::fgAbsTimeFirst    = -0.5;
const Axis_t  MHCalibrationChargeLoGainPix::fgAbsTimeLast     = 14.5;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
// Sets: 
// - the default number for fNbins        (fgChargeNbins)
// - the default number for fFirst        (fgChargeFirst)
// - the default number for fLast         (fgChargeLast)
// - the default number for fAbsTimeNbins (fgAbstTimeNbins)
// - the default number for fAbsTimeFirst (fgAbsTimeFirst)
// - the default number for fAbsTimeLast  (fgAbsTimeLast)
//
// - the default name of the  fHGausHist ("HCalibrationChargeLoGainPix")
// - the default title of the fHGausHist ("Distribution of Summed Lo Gain FADC slices Pixel ")
//
// - the default name of the  fHAbsTime ("HAbsTimeLoGainPix")
// - the default title of the fHAbsTime ("Distribution of Absolute Arrival Times Lo Gain Pixel ")
//
MHCalibrationChargeLoGainPix::MHCalibrationChargeLoGainPix(const char *name, const char *title)
{

  fName  = name  ? name  : "MHCalibrationChargeLoGainPix";
  fTitle = title ? title : "Fill the FADC sums of the Low Gain events and perform the fits Pixel ";
  
  SetNbins ( fgChargeNbins );
  SetFirst ( fgChargeFirst );
  SetLast  ( fgChargeLast  );
  
  SetAbsTimeNbins();
  SetAbsTimeFirst();
  SetAbsTimeLast();

  fHGausHist.SetName ("HCalibrationChargeLoGainPix");
  fHGausHist.SetTitle("Distribution of Summed Lo Gain FADC slices Pixel ");  

  fHAbsTime.SetName ("HAbsTimeLoGainPix");
  fHAbsTime.SetTitle("Distribution of Absolute Arrival Times Lo Gain Pixel ");  
}

















