#ifndef MARS_MHCalibrationChargePINDiode
#define MARS_MHCalibrationChargePINDiode


#ifndef MARS_MHCalibrationChargePix
#include "MHCalibrationChargePix.h"
#endif

class TH1F;
class MCalibrationChargePINDiode;
class MHCalibrationChargePINDiode : public MHCalibrationChargePix
{
private:

  static const Int_t   fgChargeNbins;     //! Default for MHGausEvents::fNBins  (now set to: 200   )
  static const Axis_t  fgChargeFirst;     //! Default for MHGausEvents::fFirst  (now set to: -0.5  )
  static const Axis_t  fgChargeLast;      //! Default for MHGausEvents::fLast   (now set to: 199.5 )
  static const Int_t   fgRmsChargeNbins;  //! Default for fRmsChargeNBins       (now set to: 100   )
  static const Axis_t  fgRmsChargeFirst;  //! Default for fRmsChargeFirst       (now set to: 0.    )
  static const Axis_t  fgRmsChargeLast;   //! Default for fRmsChargeLast        (now set to: 100.  )
  static const Int_t   fgAbsTimeNbins;    //! Default for fAbsTimeNBins         (now set to: 30    )
  static const Axis_t  fgAbsTimeFirst;    //! Default for fAbsTimeFirst         (now set to: -0.5  )
  static const Axis_t  fgAbsTimeLast;     //! Default for fAbsTimeLast          (now set to: 29.5  )

  MCalibrationChargePINDiode *fPINDiode; //! Storage container of the results

  TH1F fHRmsCharge;                      // Histogram containing Variance of summed FADC slices

  Int_t   fRmsChargeNbins;               // Number of  bins used for the fHRmsCharge
  Axis_t  fRmsChargeFirst;               // Lower bound bin used for the fHRmsCharge
  Axis_t  fRmsChargeLast;                // Upper bound bin used for the fHRmsCharge

  Float_t fRmsChargeMean;                //  Mean of the Gauss fit               
  Float_t fRmsChargeSigma;               //  Sigma of the Gauss fit             
  Float_t fRmsChargeMeanErr;             //  Error of the mean of the Gauss fit 
  Float_t fRmsChargeSigmaErr;            //  Error of the sigma of the Gauss fit

public:

  MHCalibrationChargePINDiode(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargePINDiode(){}

  Bool_t SetupFill(const MParList *pList);
  Bool_t ReInit   (      MParList *pList);
  Bool_t Fill     (const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize();

  // Setters
  void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)        { fAbsTimeNbins = bins;    }
  void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)        { fAbsTimeFirst = first;   }
  void SetAbsTimeLast( const Axis_t last =fgAbsTimeLast)         { fAbsTimeLast  = last;    }

  void SetRmsChargeNbins(const Int_t  bins =fgRmsChargeNbins)    { fRmsChargeNbins = bins;  }
  void SetRmsChargeFirst(const Axis_t first=fgRmsChargeFirst)    { fRmsChargeFirst = first; }
  void SetRmsChargeLast( const Axis_t last =fgRmsChargeLast)     { fRmsChargeLast  = last;  }

  // Getters
  TH1F *GetHRmsCharge()                        { return &fHRmsCharge;  }
  const TH1F *GetHRmsCharge()            const { return &fHRmsCharge;  }

  Float_t  GetRmsChargeMean()            const { return fRmsChargeMean; }
  Float_t  GetRmsChargeMeanErr()         const { return fRmsChargeMeanErr; }
  Float_t  GetRmsChargeSigma()           const { return fRmsChargeSigma; }
  Float_t  GetRmsChargeSigmaErr()        const { return fRmsChargeSigmaErr; }

  // Fill histos
  Bool_t FillRmsCharge(const Float_t q);

  // Fits
  Bool_t FitRmsCharge(Option_t *option="RQ0");

  // Draw
  void Draw(Option_t *opt="");
  
  ClassDef(MHCalibrationChargePINDiode, 1)  // Histogram class for the Calibration PIN Diode
};

#endif

