#ifndef MARS_MHPedestalCam
#define MARS_MHPedestalCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MGeomCam;
class MPedestalCam;
class MHPedestalPix;
class MHPedestalCam : public MHCalibrationCam
{

private:

  void   InitPedHists(MHPedestalPix &hist, const Int_t i, const Float_t nslices);
  
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  
  Float_t fExtractHiGainSlices;           // Number of FADC slices used for high gain signal extraction
  Float_t fExtractLoGainSlices;           // Number of FADC slices used for low  gain signal extraction

  MPedestalCam *fPedestals;               //! Pedestal Cam filled by MPedCalcPedRun
  
public:
  MHPedestalCam(const char *name=NULL, const char *title=NULL);
  ~MHPedestalCam() {}
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;
  
  ClassDef(MHPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

