#ifndef MARS_MCalibrationPix
#define MARS_MCalibrationPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MCalibrationPix : public MParContainer
{
protected:

  Int_t   fPixId;       // the pixel Id

  UInt_t  fFlags;       // Flag for the set bits
 
  Float_t fHiGainMean;      // Mean from fit to high gain values
  Float_t fHiGainMeanVar;   // Error of mean from fit to high gain values
  Float_t fHiGainSigma;     // Sigma from fit to high gain values
  Float_t fHiGainSigmaVar;  // Error of sigma from fit to high gain values
  Float_t fHiGainProb;      // Probability of fit to high gain values
  Float_t fHiGainNumPickup; // Number of pickup events in high-gain
  
  Float_t fLoGainMean;      // Mean from fit to high gain values
  Float_t fLoGainMeanVar;   // Error of mean from fit to low gain values
  Float_t fLoGainSigma;     // Sigma of from fit to low gain values
  Float_t fLoGainSigmaVar;  // Error of sigma from fit to low gain values
  Float_t fLoGainProb;      // Probability of fit to low gain values
  Float_t fLoGainNumPickup; // Number of pickup events in low-gain

  enum  { kHiGainSaturation, kExcluded, kValid };
  
public:

  MCalibrationPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationPix() {}
  
  virtual void Clear(Option_t *o="");

  // Setter
  void SetPixId( const Int_t i )   { fPixId = i; }

  void SetHiGainMean      ( const Float_t f ) { fHiGainMean      = f;   }
  void SetHiGainMeanErr   ( const Float_t f ) { fHiGainMeanVar   = f*f; }
  void SetHiGainProb      ( const Float_t f ) { fHiGainProb      = f;   }
  void SetHiGainSigma     ( const Float_t f ) { fHiGainSigma     = f;   }
  void SetHiGainSigmaErr  ( const Float_t f ) { fHiGainSigmaVar  = f*f; }
  void SetHiGainNumPickup ( const Float_t f ) { fHiGainNumPickup = f;   }

  void SetLoGainMean      ( const Float_t f ) { fLoGainMean      = f;   }
  void SetLoGainMeanErr   ( const Float_t f ) { fLoGainMeanVar   = f*f; }
  void SetLoGainProb      ( const Float_t f ) { fLoGainProb      = f;   }
  void SetLoGainSigma     ( const Float_t f ) { fLoGainSigma     = f;   }
  void SetLoGainSigmaErr  ( const Float_t f ) { fLoGainSigmaVar  = f*f; }
  void SetLoGainNumPickup ( const Float_t f ) { fLoGainNumPickup = f;   }

  void SetMean       ( const Float_t f ) { IsHiGainSaturation() ? fLoGainMean = f       : fHiGainMean = f      ; }
  void SetMeanErr    ( const Float_t f ) { IsHiGainSaturation() ? fLoGainMeanVar = f*f  : fHiGainMeanVar = f*f ; }
  void SetProb       ( const Float_t f ) { IsHiGainSaturation() ? fLoGainProb = f       : fHiGainProb = f      ; }
  void SetSigma      ( const Float_t f ) { IsHiGainSaturation() ? fLoGainSigma = f      : fHiGainSigma = f     ; }
  void SetSigmaErr   ( const Float_t f ) { IsHiGainSaturation() ? fLoGainSigmaVar = f*f : fHiGainSigmaVar = f*f; }
  void SetNumPickup  ( const Float_t f ) { IsHiGainSaturation() ? fLoGainNumPickup = f  : fHiGainNumPickup = f ; }
  
  void SetExcluded        ( const Bool_t  b = kTRUE );
  void SetHiGainSaturation( const Bool_t  b = kTRUE );
  void SetValid           ( const Bool_t  b = kTRUE );

  // Getters
  Float_t GetHiGainMean     () const { return fHiGainMean   ;   }
  Float_t GetHiGainMeanErr  () const;
  Float_t GetHiGainProb     () const { return fHiGainProb   ;   }
  Float_t GetHiGainSigma    () const { return fHiGainSigma  ;   }
  Float_t GetHiGainSigmaErr () const;
  Float_t GetHiGainNumPickup() const { return fHiGainNumPickup; }

  virtual Float_t GetLoGainMean     () const { return fLoGainMean   ;   }
  virtual Float_t GetLoGainMeanErr  () const;
  virtual Float_t GetLoGainProb     () const { return fLoGainProb   ;   }
  virtual Float_t GetLoGainSigma    () const { return fLoGainSigma  ;   }
  virtual Float_t GetLoGainSigmaErr () const;
  virtual Float_t GetLoGainNumPickup() const { return fLoGainNumPickup; }

  Float_t GetMean       () const { return IsHiGainSaturation() ? GetLoGainMean()      : GetHiGainMean()     ; }
  Float_t GetMeanErr    () const { return IsHiGainSaturation() ? GetLoGainMeanErr()   : GetHiGainMeanErr()  ; }
  Float_t GetProb       () const { return IsHiGainSaturation() ? GetLoGainProb()      : GetHiGainProb()     ; }
  Float_t GetSigma      () const { return IsHiGainSaturation() ? GetLoGainSigma()     : GetHiGainSigma()    ; }
  Float_t GetSigmaErr   () const { return IsHiGainSaturation() ? GetLoGainSigmaErr()  : GetHiGainSigmaErr() ; }
  Float_t GetNumPickup  () const { return IsHiGainSaturation() ? GetLoGainNumPickup() : GetHiGainNumPickup(); }

  Int_t   GetPixId      () const { return fPixId ;  }

  Bool_t  IsHiGainSaturation() const;
  Bool_t  IsExcluded()         const;
  Bool_t  IsValid   ()         const;

  ClassDef(MCalibrationPix, 1)	// Base class Container for Calibration Results Pixel
};

#endif

