#ifndef MARS_MCalibrationQEPix
#define MARS_MCalibrationQEPix

#ifndef MARS_MCalibrationPix
#include "MCalibrationPix.h"
#endif

class MCalibrationQEPix : public MCalibrationPix
{
private:

  Float_t fQEGreen;          // Calibrated quantum efficiency at 520 nm
  Float_t fQEBlue;           // Calibrated quantum efficiency at 460 nm
  Float_t fQEUV;             // Calibrated quantum efficiency at 370 nm
  Float_t fQECT1;            // Calibrated quantum efficiency at 370 nm
  Float_t fQEGreenErr;       // Uncertainty calibrated QE at 520 nm
  Float_t fQEBlueErr;        // Uncertainty calibrated QE at 460 nm
  Float_t fQEUVErr;          // Uncertainty calibrated QE at 370 nm
  Float_t fQECT1Err;         // Uncertainty calibrated QE at 370 nm
  
public:

  MCalibrationQEPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationQEPix() {}
  
  void Clear(Option_t *o="");

  // Setters
  void SetQE   ( const Float_t qe   , const PulserColor_t col );
  void SetQEErr( const Float_t qeerr, const PulserColor_t col );

  // Getters
  Float_t GetQE   ( const PulserColor_t col )  const;
  Float_t GetQEErr( const PulserColor_t col )  const;

  // Miscellaneous
  Bool_t CheckQEValidity();

  ClassDef(MCalibrationQEPix, 1)	// Container Quantum Efficieny Calibration Results Pixel
};

#endif

