#ifndef MARS_MCalibrationChargePINDiode
#define MARS_MCalibrationChargePINDiode

#ifndef MARS_MCalibrationPix
#include "MCalibrationPix.h"
#endif

class MCalibrationChargePINDiode : public MCalibrationPix
{
private:

  static const Float_t fgChargeLimit;             //! Default for fChargeLimit
  static const Float_t fgChargeErrLimit;          //! Default for fChargeErrLimit
  static const Float_t fgChargeRelErrLimit;       //! Default for fChargeRelErrLimit
  static const Float_t fgConvPhotons;             //! Default for fConversionChargePhotons
  static const Float_t fgConvPhotonsErr;          //! Default for fConversionChargePhotonsErr
  static const Float_t gkPINDiodeArea;            //! PIN Diode Effective Area in mm^2  
  static const Float_t gkFluxCameravsPINDiode;    //! Flux Conversion PIN Diode - inner pixel
  static const Float_t gkFluxCameravsPINDiodeErr; //! Error of flux conv. PIN Diode - inner pixel
  static const Float_t gkPINDiodeQEGreen;         //! Quantum Efficiency at 520 nm
  static const Float_t gkPINDiodeQEBlue;          //! Quantum Efficiency at 460 nm
  static const Float_t gkPINDiodeQEUV;            //! Quantum Efficiency at 370 nm
  static const Float_t gkPINDiodeQECT1;           //! Quantum Efficiency at 370 nm
  static const Float_t gkPINDiodeQEGreenErr;      //! Uncertainty QE at 520 nm
  static const Float_t gkPINDiodeQEBlueErr ;      //! Uncertainty QE at 460 nm
  static const Float_t gkPINDiodeQEUVErr   ;      //! Uncertainty QE at 370 nm
  static const Float_t gkPINDiodeQECT1Err  ;      //! Uncertainty QE at 370 nmu
 

  Float_t fAbsTimeMean;                   // Mean Absolute Arrival Time
  Float_t fAbsTimeRms;                    // RMS Mean Absolute Arrival Time
  Byte_t  fCalibFlags;                    // Bit-field for the class-own bits
  Float_t fChargeLimit;                   // Limit (in units of PedRMS) for acceptance fitted mean charge
  Float_t fChargeErrLimit;                // Limit (in units of PedRMS) for acceptance fitted charge sigma
  Float_t fChargeRelErrLimit;             // Limit (in units of Error of fitted charge) for acceptance fitted mean  
  Float_t fConvPhotons;                   // Mean conv. PIN Diode charge to number of incident photons
  Float_t fConvPhotonsErr;                // Error mean conv. PIN Diode charge to nr. incident photons
  Float_t fConvertedPhotons;              // Number photons incidident on PIN Diode
  Float_t fConvertedPhotonsErr;           // Error on nr. photons incid. on PIN Diode
  Float_t fMeanFluxOutsidePlexiglass;     // Mean number photons in INNER PIXEL outside plexiglass
  Float_t fMeanFluxErrOutsidePlexiglass;  // Error on nr. photons in INNER PIXEL outside plexiglass
  Float_t fPed;                           // Mean pedestal (from MPedestalPix)
  Float_t fPedRms;                        // Pedestal  RMS (from MPedestalPix)
  Float_t fRmsChargeMean;                 // Mean of RMS of summed FADC slices distribution 
  Float_t fRmsChargeMeanErr;              // Error on Mean RMS summed FADC slices distribution 
  Float_t fRmsChargeSigma;                // Sigma of RMS of summed FADC slices distribution    
  Float_t fRmsChargeSigmaErr;             // Error on Sigma RMS summed FADC slices distribution 
  PulserColor_t fColor;                   // Colour of the pulsed LEDs

  enum  { kOscillating,
          kChargeFitValid, kTimeFitValid, 
	  kFluxOutsidePlexiglassAvailable  }; // Possible bits to be set

public:

  MCalibrationChargePINDiode(const char *name=NULL, const char *title=NULL);
  ~MCalibrationChargePINDiode() {}
  
  void Clear(Option_t *o="");
  
  // Setters
  void SetAbsTimeMean      ( const Float_t f )                     { fAbsTimeMean       = f; }
  void SetAbsTimeRms       ( const Float_t f )                     { fAbsTimeRms        = f; }
  void SetChargeLimit      ( const Float_t f=fgChargeLimit       ) { fChargeLimit       = f; }
  void SetChargeErrLimit   ( const Float_t f=fgChargeErrLimit    ) { fChargeErrLimit    = f; }
  void SetChargeRelErrLimit( const Float_t f=fgChargeRelErrLimit ) { fChargeRelErrLimit = f; }
  void SetColor            ( const PulserColor_t color           ) { fColor = color;         }
  void SetConvPhotons      ( const Float_t f=fgConvPhotons       ) { fConvPhotons       = f; }  
  void SetConvPhotonsErr   ( const Float_t f=fgConvPhotonsErr    ) { fConvPhotonsErr    = f; }  
  void SetPedestal         (       Float_t ped, Float_t pedrms   );
  void SetRmsChargeMean    ( const Float_t f )                     { fRmsChargeMean     = f; }
  void SetRmsChargeMeanErr ( const Float_t f )                     { fRmsChargeMeanErr  = f; }
  void SetRmsChargeSigma   ( const Float_t f )                     { fRmsChargeSigma    = f; }
  void SetRmsChargeSigmaErr( const Float_t f )                     { fRmsChargeSigmaErr = f; }
  void SetOscillating      ( const Bool_t b=kTRUE );
  void SetChargeFitValid   ( const Bool_t b=kTRUE );
  void SetTimeFitValid     ( const Bool_t b=kTRUE );
  void SetFluxOutsidePlexiglassAvailable ( const Bool_t b = kTRUE );

  // Getters
  Float_t GetMeanFluxOutsidePlexiglass()    const { return fMeanFluxOutsidePlexiglass; }
  Float_t GetMeanFluxErrOutsidePlexiglass() const { return fMeanFluxErrOutsidePlexiglass; }

  // Pedestals
  Float_t GetAbsTimeMean()     const { return fAbsTimeMean; }
  Float_t GetAbsTimeRms ()     const { return fAbsTimeRms;  }
  Float_t GetPed()             const { return fPed;         }
  Float_t GetPedRms()          const { return fPedRms;      }

  Bool_t  IsChargeFitValid()    const;
  Bool_t  IsTimeFitValid()      const;

  Bool_t  CalcFluxOutsidePlexiglass();

  ClassDef(MCalibrationChargePINDiode, 1)	// Container Charge Calibration Results PIN Diode
};

#endif   /* MARS_MCalibrationChargePINDiode */









