#ifndef MARS_MCalibrationChargeCam
#define MARS_MCalibrationChargeCam

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class TH1D;
class TH2D;

class MCalibrationChargeCam : public MCalibrationCam
{
private:
  
  TH1D* fOffsets;                    //! Histogram with Higain-vs-LoGain fit result Offsets
  TH1D* fSlopes;                     //! Histogram with Higain-vs-LoGain fit result Slopes
  TH2D* fOffvsSlope;                 //! Histogram with Higain-vs-LoGain fit result Offsets vs. Slopes

  enum  { kFFactorMethodValid };

  Byte_t  fFlags;                    // Bit-field to hold the flags
  
public:

  MCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationChargeCam();
  
  void   Clear ( Option_t *o="" );

  // Setters   
  void   SetFFactorMethodValid     ( const Bool_t  b=kTRUE );

  // Getters
  Bool_t GetConversionFactorFFactor( Int_t ipx, Float_t &mean, Float_t &err, Float_t &ffactor );

  Bool_t IsFFactorMethodValid()      const;

  // Prints
  void Print(Option_t *o="")         const;
  
  // Draws
//  void DrawHiLoFits();
  
  // Others
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t num)   const;    

  ClassDef(MCalibrationChargeCam, 1) // Container Charge Calibration Results Camera
};

#endif
