#ifndef MARS_MCalibrationCam
#define MARS_MCalibrationCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MCalibrationPix;
class MBadPixelsPix;
class MBadPixelsCam;
class MGeomCam;

class MCalibrationCam : public MParContainer, public MCamEvent
{

public:

  enum PulserColor_t { kCT1=0, kGREEN=1, kBLUE=2, kUV=3 }; // Possible Pulser colours
  static const Int_t gkNumPulserColors;                     // Number of Pulser colours (now set to: 4)
  
protected:
  
  PulserColor_t fPulserColor;        // Colour of the pulsed LEDs

  TClonesArray *fPixels;             //-> Array of MCalibrationPix, one per pixel
  TClonesArray *fAverageAreas;       //-> Array of MCalibrationPix, one per pixel area
  TClonesArray *fAverageSectors;     //-> Array of MCalibrationPix, one per camera sector
  TClonesArray *fAverageBadAreas;    //-> Array of MBadPixelsPix,   one per pixel area
  TClonesArray *fAverageBadSectors;  //-> Array of MBadPixelsPix,   one per camera sector
  
public:

  MCalibrationCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationCam();
  
  virtual void Clear           ( Option_t *o="");
  virtual void DrawPixelContent( Int_t num) const;    

  // Getters
  const Int_t            GetAverageAreas     ()           const;
        MCalibrationPix &GetAverageArea      ( UInt_t i );
  const MCalibrationPix &GetAverageArea      ( UInt_t i ) const;
        MBadPixelsPix   &GetAverageBadArea   ( UInt_t i );
  const MBadPixelsPix   &GetAverageBadArea   ( UInt_t i ) const;
        MBadPixelsPix   &GetAverageBadSector ( UInt_t i );
  const MBadPixelsPix   &GetAverageBadSector ( UInt_t i ) const;
        MCalibrationPix &GetAverageSector    ( UInt_t i );
  const Int_t            GetAverageSectors   ()           const;  
  const MCalibrationPix &GetAverageSector    ( UInt_t i ) const;
  virtual Bool_t         GetPixelContent     ( Double_t &val, Int_t idx, 
                                               const MGeomCam &cam, Int_t type=0) const;
  const PulserColor_t    GetPulserColor()                 const { return fPulserColor; }
  const Int_t            GetSize()                        const;

        MCalibrationPix &operator[]          ( UInt_t i );
  const MCalibrationPix &operator[]          ( UInt_t i ) const;

  // Inits
  void  Init               ( const MGeomCam &geom       );
  void  InitSize           ( const UInt_t i             );
  void  InitAverageAreas   ( const UInt_t i             );
  void  InitAverageSectors ( const UInt_t i             );

  // Setters
  void  SetPulserColor     ( const PulserColor_t col=kCT1 )  { fPulserColor = col; }
  
  ClassDef(MCalibrationCam, 1)	// Base class Container for Calibration Results Camera
};

#endif
