#ifndef MARS_MJCalibration
#define MARS_MJCalibration

#ifndef MARS_MCalibrationChargeCam
#include "MCalibrationChargeCam.h"
#endif
#ifndef MARS_MCalibrationQECam
#include "MCalibrationQECam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class TCanvas;
class MHCamera;
class MCamEvent;
class MRunIter;
class MParList;
class MPedestalCam;
class MJCalibration : public MParContainer
{
private:

  TString fOutputPath;                                     // Path to the output files
  
  MRunIter *fRuns;                                         // Calibration files
  
  MCalibrationChargeCam fCalibrationCam;                   // Calibration conversion factors FADC2Phe
  MCalibrationQECam     fQECam;                            // Quantum efficiency, can be set from previous runs
  MBadPixelsCam         fBadPixels;                        // Bad Pixels cam, can be set from previous runs
  
  void DrawProjection   ( MHCamera *obj, Int_t fit) const; // Draw projection of pixels values
  void DrawRadialProfile( MHCamera *obj)            const; // Draw projection of pixels values onto camera radius
  void CamDraw(TCanvas &c, const Int_t x, const Int_t y, const MHCamera &cam1,
               const Int_t fit, const Int_t rad=0);        // Draw histograms into the MStatusDisplay
  
  void   DisplayResult(MParList &plist);
  Bool_t WriteResult();
  
public:

  MJCalibration(const char *name=NULL, const char *title=NULL);
  
  void SetInput(MRunIter *iter) { fRuns=iter; }
  void SetOutputPath(const char *path=".");
  
  TString GetOutputFile() const;
  
  MCalibrationChargeCam &GetCalibrationCam()     { return fCalibrationCam; }
  MCalibrationQECam     &GetQECam()              { return fQECam;          }    
  const MBadPixelsCam   &GetBadPixels() const    { return fBadPixels;      }
  
  void SetBadPixels(const MBadPixelsCam &bad)    { bad.Copy(fBadPixels);   }
  void SetQECam    (const MCalibrationQECam &qe) { qe.Copy(fQECam);        }    
  
  Bool_t ReadCalibrationCam();
  Bool_t ProcessFile( MPedestalCam &pedcam );
  Bool_t Process    ( MPedestalCam &pedcam );
  
  ClassDef(MJCalibration, 0) // Tool to run a calibration per pulser colour and intensity
};

#endif
