#ifndef MARS_MCalibrateRelTimes
#define MARS_MCalibrateRelTimes

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrateRelTimes                                                      //
//                                                                         //
// Calculates the relative arrival time and applies the offset,            //
// stored in MCalibrationRelTimePix                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MBadPixelsCam;
class MCalibrationRelTimeCam;
class MArrivalTimeCam;
class MCerPhotEvt;
class MCalibrateRelTimes : public MTask
{
private:
    MGeomCam               *fGeomCam;      // Camera geometry container
    MCalibrationRelTimeCam *fCalibrations; // Calibration rel. time constants
    MBadPixelsCam          *fBadPixels;    // Bad Pixels information
    MArrivalTimeCam        *fSignals;      // Extracted Arrival Time
    MCerPhotEvt            *fCerPhotEvt;   // Cerenkov Photon Event used for calculation

    Int_t PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Int_t Process();

public:

    MCalibrateRelTimes(const char *name=NULL, const char *title=NULL);

    ClassDef(MCalibrateRelTimes, 0)   // Task to calculate calibrated relative arrival times
};
 

#endif
