#ifndef MARS_MHCamEventRot
#define MARS_MHCamEventRot

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

class TH2D;

class MGeomCam;
class MParList;
class MTime;
class MPointingPos;
class MObservatory;

class MHCamEventRot : public MH
{
private:
    MGeomCam      *fGeom;        //! container storing the camera geometry
    MTime         *fTime;        //! container to take the event time from
    MPointingPos  *fPointPos;    //! container to take pointing position from
    MObservatory  *fObservatory; //! conteiner to take observatory location from

    TH2D    fHist;               // Alpha vs. x and y

    Int_t fType;

    Double_t fRa;
    Double_t fDec;

    //Int_t DistancetoPrimitive(Int_t px, Int_t py);
    //void Modified();

    //void ProjectOff(TH2D *h);
    //void ProjectOn(TH2D *h);

    TObject *GetCatalog();

public:
    MHCamEventRot(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH1 *GetHistByName(const TString name) { return &fHist; }

    //void FitSignificance(Float_t sigint=15, Float_t sigmax=70, Float_t bgmin=40, Float_t bgmax=70, Byte_t polynom=1); //*MENU*
    //void FitSignificanceStd() { FitSignificance(); } //*MENU*

    //void SetDistMin(Float_t dist) { fDistMin = dist; }

    //void SetAlphaCut(Float_t alpha); //*MENU*
    //void SetAlphaPlus5()  { SetAlphaCut(fAlphaCut+5); } //*MENU*
    //void SetAlphaMinus5() { SetAlphaCut(fAlphaCut-5); } //*MENU*

    //void SetBgMean(Float_t alpha); //*MENU*
    //void SetBgMeanPlus5()  { SetBgMean(fBgMean+5); } //*MENU*
    //void SetBgMeanMinus5() { SetBgMean(fBgMean-5); } //*MENU*

    //void Paint(Option_t *opt="");
    void Draw(Option_t *option="");

    //static Double_t Significance(Double_t s, Double_t b);
    //static Double_t SignificanceLiMa(Double_t s, Double_t b, Double_t alpha=1);

    ClassDef(MHCamEventRot, 1) //2D-histogram in MCamEvent data (derotated)
};

#endif
