#ifndef MARS_MExtractFixedWindowPeakSearch
#define MARS_MExtractFixedWindowPeakSearch

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MExtractFixedWindowPeakSearch : public MExtractor
{
private:

  static const Byte_t fgHiGainFirst;
  static const Byte_t fgHiGainLast;
  static const Byte_t fgLoGainFirst;
  static const Byte_t fgLoGainLast;
  static const Byte_t fgHiGainWindowSize;     // The extraction window Hi-Gain
  static const Byte_t fgLoGainWindowSize;     // The extraction window Lo-Gain
  static const Byte_t fgPeakSearchWindowSize; // The window in which the global peak is searched for

  Byte_t  fPeakSearchWindowSize; // Size of FADC window in the search for the highest peak of all pixels.

  Byte_t  fWindowSizeHiGain;     // Number of Hi Gain slices in window
  Byte_t  fWindowSizeLoGain;     // Number of Lo Gain slices in window

  void   FindSignalHiGain(Byte_t *ptr, Int_t last, Int_t &sum, Byte_t &sat) const;
  void   FindSignalLoGain(Byte_t *ptr, Int_t last, Int_t &sum, Byte_t &sat) const;  

  void   FindPeak(Byte_t *ptr, Byte_t window, Byte_t &startslice, Int_t &signal, Int_t &sat) const;

  Int_t  Process();

public:

    MExtractFixedWindowPeakSearch(const char *name=NULL, const char *title=NULL);

    void SetWindows(Byte_t windowh=fgHiGainWindowSize, Byte_t windowl=fgLoGainWindowSize, 
		    Byte_t peaksearchwindow=fgPeakSearchWindowSize);

    ClassDef(MExtractFixedWindowPeakSearch, 0) // Signal Extractor for fixed size trigger-corrected extraction window 
};

#endif
