#ifndef MARS_MJExtractCalibTest
#define MARS_MJExtractCalibTest

#ifndef MARS_MHCalibrationTestCam
#include "MHCalibrationTestCam.h"
#endif
#ifndef MARS_MPedPhotCam
#include "MPedPhotCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif
#ifndef MARS_MGCamDisplays
#include "MGCamDisplays.h"
#endif

class MRunIter;
class MParList;
class MPedestalCam;
class MCalibrationChargeCam;
class MCalibrationQECam;
class MExtractor;
class MJExtractCalibTest : public MParContainer, public MGCamDisplays
{
private:

  TString fOutputPath;

  MRunIter   *fRuns;                                       // Data files
  MExtractor *fExtractor;                                  // Signal extractor
  
  MBadPixelsCam        fBadPixels;
  MHCalibrationTestCam fTestCam;
  MPedPhotCam          fPedPhotCam;

  Bool_t ReadPedPhotCam();
    
  void   DisplayResult(MParList &plist);
  
  Bool_t ProcessFileD(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam);
  Bool_t ProcessFileP(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam);

public:
  MJExtractCalibTest(const char *name=NULL, const char *title=NULL);
  
  void SetInput(MRunIter *iter) { fRuns = iter; }
  void SetOutputPath(const char *path=".");
  
  TString GetOutputFileP() const;
  TString GetOutputFileD() const;
  
  MHCalibrationTestCam &GetTestCam()    { return fTestCam; }
  MPedPhotCam          &GetPedPhotCam() { return fPedPhotCam; }
  const MBadPixelsCam &GetBadPixels()  const { return fBadPixels; }
  
  void SetExtractor(MExtractor* ext)              { fExtractor = ext; }
  void SetBadPixels(const MBadPixelsCam &bad) { bad.Copy(fBadPixels); }
  
  Bool_t ProcessD(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam);
  Bool_t ProcessP(MPedestalCam &pedcam, MCalibrationChargeCam &calcam, MCalibrationQECam &qecam);
  
  ClassDef(MJExtractCalibTest, 0) // Tool to extract, calibrate and test the signal 
};

#endif
