/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 1/2004 <mailto:tbretz@astro.uni-wuerzburg.de>
!   Author(s): Javier Rico,  4/2004 <mailto:jrico@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  MRunIter
//
//  Use this to iterate over run-files giving only the run-number.
//
//  You need the specify the run-file root-directory (eg /data/MAGIC).
//
/////////////////////////////////////////////////////////////////////////////
#include "MRunIter.h"

#include <TSystem.h>
#include <iostream>

ClassImp(MRunIter);

using namespace std;

Int_t MRunIter::AddRun(UInt_t run, const char *path)
{
    TString p(path);

    if (p.IsNull())
        p = fPath;

    if (p.IsNull())
        p = ".";

    MDirIter Next(p, Form("*_%05d_*_*.root", run), -1);

    const TString name(Next());
    if (name.IsNull())
        return 0;

    AddRunNumber(run);

    return AddDirectory(gSystem->DirName(name), gSystem->BaseName(name), -1);
}

// --------------------------------------------------------------------------
//
// Add runs specified in a character chain with the format:
// run1,run2-run3,run4-run5,...
// e.g  if runrange="100,105-107,110-112,115" 
// runs 100,105,106,107,110,111,112 and 115 are included in the iterator list
//
Int_t MRunIter::AddRuns(const char* runrange, const char* path)
{ 
  char* last;
  char  chcopy[100];
  Int_t lowrun=-1;
  Int_t upprun;
  Int_t totdir=0;

  //  cout << "Analyzing chain " << runrange << " in path " << path << endl;

  sprintf(chcopy,"%s",runrange);
  last=&chcopy[0];

  // loop over the elements of the character chain (break inside the loop)
  for(char* cp=last;cp;cp++)
    {
      // look for a digit, a '-' or a ',' or end of string
      char c=*cp;
      if(! ((c>='0' && c<='9') || c=='-' || c==',' || c=='\0'))
	return totdir;
      
      // if '-' is found, save the previous number as initial run
      if(c=='-' && lowrun<0)
	{
	  char chrun[100];
	  strncpy(chrun,last,cp-last);
	  lowrun=atoi(chrun);	  	  
	  last=cp+1;
	}
      // if ',' or the end of the string are found, save the previous run or run range
      if(c==',' || c=='\0')
	{
	  char chrun[100];
	  strncpy(chrun,last,cp-last);
	  upprun=atoi(chrun);
	  if(lowrun>=0 && lowrun<=upprun)
	    totdir+=AddRuns(lowrun,upprun,path);
	  else if(lowrun<0)
	    totdir+=AddRun(upprun,path);	  
	  
	  if(c=='\0')
	    break;
	  lowrun=-1;
	  last=cp+1;
	}
    }
  return totdir;
}
