
#ifndef HVSTATUS_H_SEEN
#define HVSTATUS_H_SEEN

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/socket.h>
#include <unistd.h>
#include <pthread.h>

#include "Types.h"
#include "HVConfig.h"

typedef enum stateenum { active, stopped, na } state_enum;
typedef enum connection  { disconnected, connected } connect_enum;

typedef struct status_str {
  
  pthread_t HVMonitor;

  char Prompt[MAX_COM_SIZE];
  
  bool Log;
  bool Verbose;

  char Param[10][MAX_COM_SIZE], *Pc; // For parser
  int NParam;
  
  connect_enum cc_state;

  int Socket;                   // PrintMessage() uses this socket, -1 if not connected
  pthread_t SocketThread;       // exit function sends signal to this thread

  int CCPort;
  char CCClient[STR_LENGTH];
  
  char** fUSBDevice;
  int USBDeviceNumber[MAX_NUM_HVBOARDS];
  int USBMinDeviceNumber;
  int USBMaxDeviceNumber;

  int NumHVBoards;
  int FirstBoard;
  int LastBoard;

  int FirstChain;
  int LastChain;
  
  unsigned int VRef[MAX_NUM_HVBOARDS][MAX_NUM_CHAINS];     
  unsigned int HV[MAX_NUM_HVBOARDS][MAX_NUM_CHAINS][MAX_NUM_CHANNELS];      // HV value in DAC
  float HVV[MAX_NUM_HVBOARDS][MAX_NUM_CHAINS][MAX_NUM_CHANNELS];            // HV value in volts

  float fTimeOut;
  float fStatusRefreshRate;

  bool OC[MAX_NUM_HVBOARDS][MAX_NUM_CHAINS]; // Overcurrent flag
  bool MR[MAX_NUM_HVBOARDS];                 // Manual reset
  
  bool isok[MAX_NUM_HVBOARDS];
  state_enum   state;

  bool IsUpdated[MAX_NUM_HVBOARDS];

  int WC[2][MAX_NUM_HVBOARDS];
  
  int CCCommand;
  int Exit;
  int Stop;

} Status;


void InitStatus(Status* status, HVConfig* config);
void ReInitStatus(Status* status);
void ReInitStatusOneBoard(Status* status, int board);
void PrintStatus(Status* status, HVConfig* config, FILE* fptr);
void sPrintStatus(Status* status, char* str, int i);
char* GetStateStr(Status* status);

#endif
