#ifndef MARS_MExtractPINDiode
#define MARS_MExtractPINDiode

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MExtractPINDiode                                                        //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MExtractedSignalPINDiode;
class MExtractPINDiode : public MExtractor
{
private:

  static const UInt_t fgPINDiodeIdx;  
  static const Byte_t fgHiGainFirst;     // First FADC slice Hi-Gain (currently set to: 3) 
  static const Byte_t fgHiGainLast;      // Last FADC slice Hi-Gain (currently set to: 14) 
  static const Byte_t fgLoGainFirst;     // First FADC slice Lo-Gain (currently set to: 3) 
  static const Byte_t fgLoGainLast;      // Last FADC slice Lo-Gain (currently set to: 14) 

  MExtractedSignalPINDiode  *fPINDiode;     // Extracted signal of the PIN Diode

  UInt_t  fPINDiodeIdx;
  Float_t fPedestal;
  Float_t fPedRms;
  Int_t   fNumSamples;
  Float_t fSqrtSamples;
  
  void   FindSignalandVarianceHiGain(Byte_t *ptr, Int_t &sum, Int_t &sum2, Byte_t &sat) const;
  void   FindSignalandVarianceLoGain(Byte_t *ptr, Int_t &sum, Int_t &sum2, Byte_t &sat) const;

  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  void   StreamPrimitive(ofstream &out) const;
  
public:

  MExtractPINDiode(const char *name=NULL, const char *title=NULL);

  // Setters
  void SetRange(Byte_t hifirst=0, Byte_t hilast=0, Byte_t lofirst=0, Byte_t lolast=0);
  void SetPINDiodeIdx(    const UInt_t idx=fgPINDiodeIdx    ) { fPINDiodeIdx     = idx; }   

  ClassDef(MExtractPINDiode, 0) // Signal Extractor for the PIN Diode
};

#endif
