#include <iostream.h>
#include "MMcTrig.hxx"


//==========
// MMcTrig
//    
// This class handles and contains the MonteCarlo information
// with which the events have been generated
// This information exists for each event.
 


ClassImp(MMcTrig)



MMcTrig::MMcTrig() {
  //
  //  default constructor
  //  set all values to zero

  Int_t i;

  topology     = -1 ;
  multiplicity = -1 ;
  for(i=0;i<TRIGGER_PIXELS;i++){
    threshold[i] = -1.0;
  }

  nFirstLevel  = 0 ;
  timeFirst    = -99.9;
  pixelFirst   = -9;
   
  nSecondLevel = 0 ; 

}

MMcTrig::~MMcTrig() {
  //
  //  default destructor
  //
}

void MMcTrig::Clear() {
  //
  //  
  //  reset all values to zero
  Int_t i;

  nFirstLevel  = 0 ;
  timeFirst    = -99.9;
  pixelFirst   = -9;

  nSecondLevel = 0 ;

  //  cout << "MMcTrig::Clear() " << endl ; 
}

void MMcTrig::Print(Option_t *Option) {
  //
  //  print out the data member on screen
  //
  Int_t i;

  cout <<endl << "Monte Carlo Trigger output:" <<endl;
  cout << " Topology Trigger in this event : "<<topology<<endl;
  cout << " Multiplicity Trigger in this event : "<<multiplicity<<endl;
  cout << " First  Level Trigger in this Event : "<<nFirstLevel<<endl; 
  cout << " Time of first  Level Trigger in this Event : "<< timeFirst<<endl;
  cout << " Pixels of first  Level Trigger in this Event : "<<pixelFirst<<endl;
  cout << " Second Level Trigger in this Event : " << nSecondLevel << endl ; 
  cout << endl ; 
}
