#ifndef MARS_MSrcRotate
#define MARS_MSrcRotate

#ifndef MARS_MTask
#include "MTask.h"
#endif

#include <TArrayF.h>
#include "MTime.h"
#include "MSrcPosCam.h"

class MDCA;
class MObservatory;
class MRawEvtHeader;
class MRawRunHeader;

class MSrcRotate : public MTask
{
private:
    MSrcPosCam*    fSrcPos;      //!  Pointer to the source position
    MDCA*          fDCA;         //!  Pointer to the MDCA object
    MRawEvtHeader* fEvtHeader;   //!  Pointer to the event header
    MRawRunHeader* fRunHeader;   //!  Pointer to the run header
    MObservatory*  fObservatory; //!  Pointer to the MObservatory    

    TString     fSrcPosName;
    TString     fDCAName;

    Double_t   fRA;         //  [rad] Right ascention 
    Double_t   fDEC;        //  [rad] Declination
    UInt_t     fNEvts;      //  Number of events in file
    UInt_t     fFirstEvt;   //  Event index for first event in file
    MTime      fIniTime;    //  Run initial time 
    MTime      fFinTime;    //  Run final time 
    Double_t   fDeltaT;     //  DeltaT between two events
    UInt_t     fRunNumber;  //  Current run number

    Int_t PreProcess(MParList *plist);
    Int_t Process();

public:
    MSrcRotate(const char* src="MSrcPosCam", const char* dca="MDCA",
	       const char* name=NULL, const char* title=NULL);

    void SetRAandDEC(Double_t ra, Double_t dec) {fRA=ra;fDEC=dec;};

    ClassDef(MSrcRotate, 0) // task to rotate the position of the source as a function of Azimuth and Zenith angles
};

#endif

