#ifndef CAMERA_H
#define CAMERA_H

#ifndef ROOT_TMutex
#include <TMutex.h>
#endif
#ifndef ROOT_TCondition
#include <TCondition.h>
#endif

#ifdef __CINT__
typedef unsigned long int pthread_t;
struct timeval;
#else
#include <unistd.h>
#include <sys/time.h>
#endif

#include "PixGetter.h"
#include "PixClient.h"

class Camera : public PixGetter
{
private:
    //
    // Geometry
    //
    static const int cols  = 768;
    static const int rows  = 576;
    static const int depth = 3;

    //
    // Hardware Descriptors
    //
    int fd;
    int iBufferSize;
    int iOffsets[2];

    char *pMapBuffer;

    //
    // Thread interface
    //
    unsigned long fNum;

    int fStop;
//    int fRunning;

    char fImg[cols*rows];
    struct timeval fTime;

    PixClient &fClient;

    pthread_t  fThread;
    TCondition fCond;
    TMutex    *fMutex;
    //pthread_mutex_t fMux;
    //pthread_cond_t  fCond;

    //
    // Hardware dependant functions
    //
    static void SigAlarm(int signal);

    int  Ioctl(int req, void *opt, const char *str=NULL);

    void SigInit();
    void Error(const char *str, int fatal=true);

    int  StartGrab(unsigned int frame);

    char *GetImg(unsigned int frame);

    //
    // Execution thread which processes the pictures
    //
    void Thread();
    static void *MapThread(void *arg);

    void LoopStep(const unsigned long n);

public:
    Camera(PixClient &client, Int_t ch=0);
    virtual ~Camera();

    //
    // Starts, stops the execution
    //
    void Loop(const unsigned long nof=0);
    void ExitLoop();
    int  IsRunning() const;

    //
    // Execution of one frame - this function may be overloaded!
    //
    //virtual void ProcessFrame(const unsigned long n,
    //                          byte *img, struct timeval *tm);

    //
    // hardware features
    //
    void SetPicPar(int  bright, int  hue, int  contrast);
    void GetPicPar(int *bright, int *hue, int *contrast);

    ClassDef(Camera, 0)
};

#endif
