#ifndef MARS_MString
#define MARS_MString

#ifndef ROOT_TString
#include <TString.h>
#endif

#include <stdio.h>
#include <stdarg.h>

class MString : public TString
{
public:
    MString &Print(const char *fmt, ...)
    {
        va_list ap;
        va_start(ap, fmt);

        Int_t n=256;

        char *ret=0;

        while (1)
        {
            ret = new char[n+1];
            Int_t sz = vsnprintf(ret, n, fmt, ap);
            if (sz<=n)
                break;

            n *= 2;
            delete [] ret;
        };

        va_end(ap);

        *static_cast<TString*>(this) = ret;

        delete [] ret;

        return *this;
    }
    ClassDef(MString, 1)
};

#endif
