#ifndef MARS_MSrcPlace
#define MARS_MSrcPlace

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MDCA;
class MSrcPosCam;
class TH2F;

class MSrcPlace : public MTask
{
 public:
  enum OnOffMode_t {kOn=0,kOff};
  
 private:
  MSrcPosCam*  fSrcPos;      //  Pointer to the source position
  MDCA*        fDCA;         //  Pointer to the MDCA object
  
  TString      fSrcPosName;  //  Name of the MSrcPosCam object
  TString      fDCAName;     //  Name of the MDCA object
  
  TH2F*        fHistPos;  //  histogram of the used source positions
  OnOffMode_t  fMode;        //  On/Off data mode (write/read to/from the histogram)

  virtual Int_t PreProcess(MParList *plist);
  virtual Int_t Process();
  virtual Int_t PostProcess();

  void  SavePosIntoHisto();
  void  ReadPosFromHisto();


 public:
  MSrcPlace(const char* histname="HistSrcPos",
	    const char* src="MSrcPosCam", const char* dca="MDCA",
	    const char* name=NULL, const char* title=NULL);

  virtual ~MSrcPlace();

  void SetMode(OnOffMode_t mode)   {fMode=mode;}
  void SetSrcPosName(TString name) {fSrcPosName=name;}
  void SetDCAName(TString name)    {fDCAName=name;}

  OnOffMode_t   GetMode()            {return fMode;}
  TH2F*         GetPositionHisto()   {return fHistPos;}
  MSrcPosCam*   GetSrcPosCam()       {return fSrcPos;}
  MDCA*         GetDCA()             {return fDCA;}
  
  Int_t SearchForSrcPos(MParList *plist);
  virtual Int_t ComputeNewSrcPosition() {return kTRUE;}

  ClassDef(MSrcPlace, 0) // task to rotate the position of the source as a function of Azimuth and Zenith angles
};

#endif

