#ifndef MARS_MSrcPlace
#define MARS_MSrcPlace

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MDCA;
class MSrcPosCam;
class TH2F;

class MSrcPlace : public MTask
{
 public:
  enum OnOffMode_t {kOn=0,kOff};
  
 private:
  MSrcPosCam*  fSrcPosIn;       //  Pointer to the input source position container
  MSrcPosCam*  fSrcPosOut;      //  Pointer to the output source position container
  MDCA*        fDCA;            //  Pointer to the output MDCA container
  
  TString      fSrcPosInName;   //  Name of the input MSrcPosCam object
  TString      fSrcPosOutName;  //  Name of the output MSrcPosCam object
  TString      fDCAName;        //  Name of the MDCA object

  TString      fHistoName;      //  Name of internal histogram
  Float_t      fHistoBinPrec;   //  [mm] internal histo bin size 

  TH2F*        fHistPos;     //  histogram of the used source positions
  OnOffMode_t  fMode;        //  On/Off data mode (write/read to/from the histogram)
  Bool_t       fCreateHisto; //  flag to decide whether internal histo is created or not

  void  SavePosIntoHisto();
  void  ReadPosFromHisto();

  virtual Int_t Process();
  virtual Int_t PostProcess();

 protected:
  virtual Int_t PreProcess(MParList *plist);

 public:
  MSrcPlace(const char* srcin="MSrcPosCam",const char* srcout="MSrcPosCam", 
	    const char* dcaout="MDCA",
	    const char* name=NULL, const char* title=NULL);

  virtual ~MSrcPlace();

  void SetMode(OnOffMode_t mode)            {fMode=mode;}
  void SetInputSrcPosName(TString name)     {fSrcPosInName=name;}
  void SetOutputSrcPosName(TString name)    {fSrcPosOutName=name;}
  void SetDCAName(TString name)             {fDCAName=name;}
  void SetInternalHistoName(TString name)   {fHistoName=name;}
  void SetInternalHistoBinSize(Float_t size){fHistoBinPrec=size;}
  void SetCreateHisto(Bool_t inp=kTRUE)     {fCreateHisto=inp;}

  OnOffMode_t   GetMode()              {return fMode;}
  TH2F*         GetPositionHisto()     {return fHistPos;}
  MSrcPosCam*   GetInputSrcPosCam()    {return fSrcPosIn;}
  MSrcPosCam*   GetOutputSrcPosCam()   {return fSrcPosOut;}
  MDCA*         GetDCA()               {return fDCA;}
  TString       GetInternalHistoName() {return fHistoName;}
  
  virtual Int_t ComputeNewSrcPosition() {return kTRUE;}

  ClassDef(MSrcPlace, 0) // task to rotate the position of the source as a function of Azimuth and Zenith angles
};

#endif

