
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MDCACalc.cc                                                             //
//                                                                         //
// Author(s): S.C. Commichau, L.S. Stark, 7/2003                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MDCACalc.h"

ClassImp(MDCACalc);

using namespace std; 

MDCACalc::MDCACalc(const char *name, const char *title)
    : fDCAName("MDCA"), fFlags(0xff)
{
    fName  = name  ? name  : "MDCACalc";
    fTitle = title ? title : "Calculate Hillas, DCA and other image parameters";
    
}

Int_t MDCACalc::PreProcess(MParList *pList)
{
    fErrors = 0;

    fCerPhotEvt = (MCerPhotEvt*)pList->FindObject(AddSerialNumber("MCerPhotEvt"));
    if (!fCerPhotEvt)
    {
        *fLog << err << "MCerPhotEvt not found... aborting." << endl;
        return kFALSE;
    }

    fGeomCam = (MGeomCam*)pList->FindObject(AddSerialNumber("MGeomCam"));
    if (!fGeomCam)
    {
        *fLog << err << "MGeomCam (Camera Geometry) missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    fHillas = (MHillas*)pList->FindObject(AddSerialNumber("MHillas"));
    if (!fHillas)
    {
        *fLog << err << "MHillas missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    if (TestFlag(kCalcDCA))
        fMDCA = (MDCA*)pList->FindCreateObj("MDCA", AddSerialNumber(fDCAName));
    else
    {
        fMDCA = (MDCA*)pList->FindObject(AddSerialNumber(fDCAName), "MDCA");
        *fLog << err << fDCAName << " [MDCA] not found... aborting." << endl;
    }
    if (!fMDCA)
        return kFALSE;

    return kTRUE;
}

// If the calculation wasn't sucessfull skip this event

Int_t MDCACalc::Process()
{

    if (TestFlag(kCalcDCA))
    {
        Int_t rc = fMDCA->Calc(*fGeomCam, *fCerPhotEvt, *fHillas);
          

	if (rc == -1)
        {
	    fErrors++;
            *fLog << err << dbginf << "MDCA::Calc returned ... error!" << endl;
            return kFALSE;
        }
   }
   
    return kTRUE;
}

Int_t MDCACalc::PostProcess()
{

    *fLog << fErrors << " errors occured..." << endl;
    *fLog << endl;

    return kTRUE;
} 






