#ifndef MARS_MSrcPosFromStars
#define MARS_MSrcPosFromStars

#ifndef MARS_MSrcPlace
#include "MSrcPlace.h"
#endif

class MStarLocalCam;
class MSrcPosCam;

class MSrcPosFromStars : public MSrcPlace
{
 private:

  MStarLocalCam *fStars;

  const UInt_t fNumStars;
  Float_t fDistanceFirstStar;
  Float_t fDistanceSecondStar;

  virtual Int_t ComputeNewSrcPosition();
  virtual Int_t PreProcess(MParList *plist);
    
public:    

  MSrcPosFromStars(Float_t first=0., Float_t second=0., const char *name=NULL, const char *title=NULL);
  
  void SetDistanceFirstStar(Float_t dist) { fDistanceFirstStar = dist; }
  void SetDistanceSecondStar(Float_t dist) { fDistanceSecondStar = dist; }
  
  ClassDef(MSrcPosFromStars, 0) // task to calculate the position of the source using the position of stars
};

#endif
