#ifndef MGOCTMAIN_H
#define MGOCTMAIN_H

#include <TROOT.h> 
#include <TApplication.h> 
#include <TSystem.h> 
#include <TGClient.h> 
#include <TGButton.h>
#include <TGMenu.h>
#include <TGTab.h> 
#include <TGListBox.h> 
#include <TGPicture.h>
#include <TGFSContainer.h>
#include <TGMsgBox.h>

#include <TVirtualX.h>
#include <TGClient.h>   

/* #include <TGTextEntry.h> */
/* #include <TGLabel.h> */
/* #include <TRootEmbeddedCanvas.h> */
/* #include <TNtuple.h> */
/* #include <TFile.h> */
/* #include <TCanvas.h> */

#include "MOctTest.h" 

enum CommandIdentifiers {
  M_FILE_EXIT ,
  M_FILE_ABOUT , 

  M_BUTTON_EVTDISP , 
  M_BUTTON_PEDADC, 
  M_BUTTON_CRADC, 

  M_PBUTTON_CDIR_UP, 
  M_PBUTTON_LIST_MODE, 
  M_PBUTTON_DETAIL_MODE 
} ; 


class MGOctMain : public TGMainFrame {
 private:
  
  //
  // Create a main frame with a number of different buttons.
  //

  //   some member not connected with Gui 
  
  Char_t       fInputFile[200] ; 
  MOctTest     fOctober ; 

  //  the things for the menu bar 
    
  TGMenuBar         *fMenuBar ; 
  TGPopupMenu       *fFileMenu ;

  //   divide the Window in two different parts
  
  TGCompositeFrame  *fFrameTop ;   // top part of the main window
  TGCompositeFrame  *fFrameLow ;   // low part of the main window
  TGTab             *fTab      ;   // different tabs in the low window
  
  //   the buttons in the Top Part
  
  TGTextButton      *fButEvtDisp ; 
  TGTextButton      *fButPedADC, *fButCrADC  ; 
  
  //   the things in the file selector

  TGCompositeFrame  *fTabF1 ;                       // first tab of low part 
  TGCompositeFrame  *fTabF1a, *fTabF1b ;            // subpart of the file selector in low window
  TGListBox         *fDir ; 
  TGPictureButton   *fCdup, *fListMode, *fDetail ; 
  TGFileContainer   *fFileCont ; 
  TGListView        *fFileView ;

  //     Layout hints for different uses 
  
  TGLayoutHints     *fLayMenuBar, *fLayMenuItem ; 
  TGLayoutHints     *fLayTab ; 
  
  //     some icons and pictures often used
  
  const TGPicture   *fPicCdup, *fPicList, *fPicDetail ; 
  
 public: 
  MGOctMain(const TGWindow *p, UInt_t w, UInt_t h) ;
  
  ~MGOctMain(); 
  
  void   CloseWindow()  ; 

  Bool_t InputFileSelected() ; 
  
  Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

} ; 

#endif


