void ReadSetup(TString fname, MAstroCamera &cam)
{
    MMcConfigRunHeader *config=0;
    MGeomCam           *geom=0;

    TFile file(fname);
    TTree *tree = (TTree*)file.Get("RunHeaders");
    tree->SetBranchAddress("MMcConfigRunHeader", &config);
    if (tree->GetBranch("MGeomCam"))
        tree->SetBranchAddress("MGeomCam", &geom);
    tree->GetEntry(0);

    cam.SetMirrors(*config->GetMirrors());
    cam.SetGeom(*geom);
}

void starfield()
{
    // Name of a MC file having MGeomCam and MMcConfigRunHeader
    TString fname = "../Mars/Gamma_zbin7_90_7_53395to53399_w0.root";

    // Time for which to get the picture
    MTime time;
    time.Set(2004, 2, 28, 01, 32, 15);

    // Current observatory
    MObservatory magic1;

    // Right Ascension [h] and declination [deg] of source
    // Currently 'perfect' pointing is assumed
    const Double_t ra  = MAstro::Hms2Rad(5, 34, 31.9);
    const Double_t dec = MAstro::Dms2Rad(22, 0, 52.0);

    new TCanvas;

    // --------------------------------------------------------------------------
    // Create camera display from geometry
    //MAstroCatalog stars;     // Use this top display a catalog
    MAstroCamera stars;        // Use this top display a catalog on top of a camera
    ReadSetup(fname, stars);   // Use this top display a catalog on top of a camera
    stars.SetLimMag(6);
    stars.SetRadiusFOV(3);
    stars.SetRaDec(ra, dec);

    // Read the stars from a star catalog. The catalogs can be downloaded
    // from the Mars web page. For more information see class reference.
    stars.ReadBSC("bsc5.dat");

    stars.SetObservatory(magic1);
    stars.SetTime(time);
    stars.SetGuiActive();

    // See the cooresponding Draw-function for more options
    TObject *o = stars.Clone();
    o->SetBit(kCanDelete);
    o->Draw();

}
