#ifndef MARS_MPedCalcFromData
#define MARS_MPedCalcFromData

/////////////////////////////////////////////////////////////////////////////
//                                                                         
// MPedCalcFromData
//                                                                         
// Evaluate the pedestal from real data. Uses pixels which have no switched to Low Gain
// to take pedestals from Low Gain samples.
//
// Author: J. Flix (jflix@ifae.es)
// Date: 25-06-2004
//                                                                         
/////////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MPedCalcFromData : public MExtractor
{

    UInt_t fgDump; // Number for dumping.
    Byte_t fgLoGainFirst;      // First FADC slice Lo-Gain (currently set to: 3) 
    Byte_t fgLoGainLast;       // Last FADC slice Lo-Gain (currently set to: 14) 
    Byte_t fWindowSizeLoGain;             // Number of Lo Gain slices in window
    Byte_t HighGainThreshold;

    TArrayD fSumx;         // sum of values
    TArrayD fSumx2;        // sum of squared values

    TArrayI fEvtCounter; // Counter for dumping values to Pedestal Container
    TArrayI fTotalCounter; // Counter for dumping values to Pedestal Container

    Int_t  PreProcess ( MParList *pList );
    Bool_t ReInit     ( MParList *pList );
    Int_t  Process    ();
    Int_t  PostProcess();

public:

    MPedCalcFromData(const char *name=NULL, const char *title=NULL);
 
    void Clear(const Option_t *o="");
    void SetDumpEvents(UInt_t dumpevents = 0){fgDump = dumpevents;}
    void SetHighGainThreshold(Byte_t Threshold = 0){HighGainThreshold = Threshold;}
    void SetLoRange(Byte_t lofirst=0, Byte_t lolast=0);

    ClassDef(MPedCalcFromData, 0)   // Task to calculate pedestals from data runs 
};

#endif
