#ifndef MARS_MCalibrationChargeBlindCam
#define MARS_MCalibrationChargeBlindCam

#ifndef MARS_MCalibrationCam
#include "MCalibrationCam.h"
#endif

class MCalibrationChargeBlindPix;
class TClonesArray;
class MCalibrationChargeBlindCam : public MParContainer
{
private:

  MCalibrationCam::PulserColor_t fPulserColor;  // Colour of the pulsed LEDs

  TClonesArray *fBlindPixels;                   //-> Array of MCalibrationChargeBlindPix

  Bool_t fValid;

public:
  MCalibrationChargeBlindCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationChargeBlindCam();
  
  void   Clear ( Option_t *o="" );
  void   Copy ( TObject& obj ) const;

  // Getters
  const Int_t                          GetSize()        const;
  const MCalibrationCam::PulserColor_t GetColor() const { return fPulserColor; }

        MCalibrationChargeBlindPix &operator[] ( UInt_t i );
  const MCalibrationChargeBlindPix &operator[] ( UInt_t i ) const;

  Bool_t IsValid() const { return fValid; }

  // Setters
  void  SetColor ( const MCalibrationCam::PulserColor_t col )  { fPulserColor = col; }
  void  SetValid () { fValid = kTRUE; }

  // Inits
  void  InitSize( const UInt_t i);
  
  // Prints
  void   Print(Option_t *o="") const;

  ClassDef(MCalibrationChargeBlindCam, 1) // Container Blind Pixel Calibration Results Camera
};

#endif
