#ifndef MARS_MPedestalPix
#define MARS_MPedestalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MPedestalPix : public MParContainer
{
private:

  Float_t fPedestal;     // mean value of pedestal (PMT offset)
  Float_t fPedestalRms;  // root mean square / sigma  / standard deviation of pedestal
  Float_t fPedestalABoffset; // the difference between odd slice pedestal mean and the 
                             // total pedestal mean (fPedestal). For even slices pedestal
                             // use -fPedestalABoffset.
  UInt_t fNumEvents; // number of times, the Process was executed (to estimate the error of pedestal)
  Bool_t fValid;   // flag to set pixel valid
  
public:
  MPedestalPix();
  
  void Clear(Option_t *o="");
  
  // Using histograms
  void InitUseHists();
  
    // Setters
  void SetPedestal(const Float_t f)         { fPedestal = f; }
  void SetPedestalRms(const Float_t f)      { fPedestalRms = f; }
  void SetPedestalABoffset(const Float_t f) { fPedestalABoffset = f; }
  void SetNumEvents(const UInt_t n)         { fNumEvents = n; }

  void Set(const Float_t m, const Float_t r, const Float_t offs=0, const UInt_t n=0);
  void SetValid(const Bool_t b=kTRUE)    { fValid = b;  }
  
  // Getters
  Float_t GetPedestal()    const { return fPedestal; }
  Float_t GetPedestalRms() const { return fPedestalRms; }
  Float_t GetPedestalABoffset() const { return fPedestalABoffset; }
  Float_t GetPedestalError()    const { return fNumEvents>0 ? fPedestalRms/TMath::Sqrt((Float_t)fNumEvents)   : 0; }
  Float_t GetPedestalRmsError() const { return fNumEvents>0 ? fPedestalRms/TMath::Sqrt((Float_t)fNumEvents/2) : 0; }
  
  Bool_t IsValid()         const;

  ClassDef(MPedestalPix, 2)	// Storage Container for Pedestal information of one pixel
};

#endif

