#include <fstream>

#include "MIslands.h"

#include "MCerPhotPix.h"
#include "MCerPhotEvt.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MIslands);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor.
//
MIslands::MIslands(const char *name, const char *title)
{
    fName  = name  ? name  : "MIslands";
    fTitle = title ? title : "Storage container for the island information of one event";
    
}

// --------------------------------------------------------------------------
//
// Destructor.
//
MIslands::~MIslands()
{
}

// --------------------------------------------------------------------------
//
// Print the island parameters to *fLog
//
void MIslands::Print(Option_t *) const
{
    *fLog << all;
    *fLog << "Island Parameters (" << GetName() << ")"  << endl;
    *fLog << " - Island Number   = " << fIslNum << endl;
    for (Int_t i = 0; i< fIslNum ; i++)
      {
	*fLog << "   Island Id " << i  << endl;
    	*fLog << "    + Pixel Number = " << fPixNum[i] << endl;
    	*fLog << "    + SigToNoise = " << fSigToNoise[i] << endl;
    	*fLog << "    + TimeSpread = " << fTimeSpread[i] << endl;
    	*fLog << "    + MeanX = " << fMeanX[i] << endl;
    	*fLog << "    + MeanY = " << fMeanY[i] << endl;
    	*fLog << "    + Dist = " << fDist[i] << endl;
      }
}


