#ifndef MARS_MIslands
#define MARS_MIslands

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif


class MIslands : public MParContainer
{
private:
    // for description see MIslands.cc
    Int_t fIslNum;                 //  number of islands
    Int_t fIslId[577];             //  island Id
    Int_t fPixNum[20];             //  number of pixels in the island
    Float_t fSigToNoise[20];       //  signal to noise of the island
    Float_t fTime[20][577];        //  mean of the arrival time  
    Float_t fTimeSpread[20];       //  mean arrival time spread of the island  
    Float_t fMeanX[20];            //  mean X position of the island
    Float_t fMeanY[20];            //  mean Y position of the island
    Float_t fDist[20];    //  dist between islands and continent(larger island)

public:
    MIslands(const char *name=NULL, const char *title=NULL);
    ~MIslands();

    void Print(Option_t *opt=NULL) const;

    Int_t    GetIslNum() const                        { return fIslNum; } 
    Int_t    GetIslId(Int_t idx) const                { return fIslId[idx]; }
    Int_t    GetPixNum(Int_t isl)                     { return fPixNum[isl]; }
    Float_t  GetSigToNoise(Int_t isl)                 { return fSigToNoise[isl]; }
    Float_t  GetArrivalTime(Int_t isl, Int_t idx) { return fTime[isl][idx]; }           
    Float_t  GetTimeSpread(Int_t isl)             { return fTimeSpread[isl];}          
    Float_t  GetMeanX(Int_t isl)                  { return fMeanX[isl];}
    Float_t  GetMeanY(Int_t isl)                  { return fMeanY[isl];}
    Float_t  GetDist(Int_t isl)                   { return fDist[isl]; }

    void     SetIslNum(Int_t nisl)                    { fIslNum = nisl; }
    void     SetIslId(Int_t idx, Int_t isl)           { fIslId[idx] = isl; }
    void     SetPixNum(Int_t isl, Int_t npix)         { fPixNum[isl] = npix; }
    void     SetSigToNoise(Int_t isl, Float_t val)    { fSigToNoise[isl] = val; }
    void     SetArrivalTime(Int_t isl, Int_t idx, Float_t val)   { fTime[isl][idx] = val;}

    void     SetTimeSpread(Int_t isl, Float_t val) { fTimeSpread[isl] = val; }
    void     SetMeanX(Int_t isl, Float_t val) { fMeanX[isl]=val; }
    void     SetMeanY(Int_t isl, Float_t val) { fMeanY[isl]=val; }
    void     SetDist(Int_t isl, Float_t val) { fDist[isl]=val; }


    ClassDef(MIslands, 1) // Storage Container for Island Parameters
};

#endif
