// This macro creates a fake MCerPhotEvt container (with some clusters
// that simulate the starfield seen by the DC currents) and then applies
// the image cleaning and the Hillas algorithm to recognize and classify
// the clusters.
//
void test_findstar();
{
  // Empty container and task lists
  MParList plist;
  MTaskList tlist;
  
  plist.AddToList(&tlist);

  MCerPhotEvt DCEvt;

  MGeomCamMagic *geom; 

  const Int_t gsNpix = 577;

  Int_t startpixs[gsNpix];
  Int_t cluster[gsNpix];
  memset(cluster,-1,gsNpix*sizeof(Int_t));
  memset(startpixs,-1,gsNpix*sizeof(Int_t));


  MCerPhotPix DCpix;
  for (int t=0;i<gsNpix;i++)
    DCpix = DCevt.AddPixel(i,0.,0.);
  
  // a fake cluster:
  


}

Int_t FindStartPixels(MCerPhotEvt *evt, Int_t startpixs, MGeomCam *geom)
{
  // look for all the pixels with a DC higher than the DC of neighbour pixels 

  // loop over all pixels
  MCerPhotEvtIter Next(fEvt, kFALSE);
  
  while ((dcpix=static_cast<MCerPhotPix*>(Next())))
    {
      const Int_t pixid = dcpix->GetPixId();  //pixid  of current pixel

      const MGeomPix &pix = (*geom)[pixid]; // MGeomCam pixel
      
      currDC = dcpix->GetNumPhotons();  // DC of current pixel

      // look for the max DC in the neighbors pixels
      Float_t macDC = 0;
      for (Int_t j=0; j<pix.GetNumNeighbors()-1; j++) 
	if ( evt[pix.GetNeighbor(j)]->GetNumPhotons() > maxDC) 
	  maxDC = evt[pix.GetNeighbor(j)]->GetNumPhotons();
     
      // a starting pixel was found: it is added to the array and the pointer
      // to the array is increased by 1
      if ( currDC > maxDC)
	*(startpixs++) = currDC;
    }
}

Int_t FindCluster(Int_t startpix, Int_t cluster, MGeomCam *geom)
{


} 
