/* ======================================================================== *\!
!   Author(s): Javier Rico
\* ======================================================================== */

void observationTime(
		     Int_t iniRun=0,
		     Int_t finRun=99999,
		     TString filename="/mnt/users/jrico/magic/mars/mars/mtemp/mifae/hillas/AllCrabNebula_3015_kDefault_MispE.root"
)
{    
    // define files, chains...
    TChain* t= new TChain("Parameters");
    t->Add(filename);

    // define aliases
    t->SetAlias("run",     "MRawRunHeader.fRunNumber");
    t->SetAlias("runiniT", "MRawRunHeader.fRunStart.fTime.fMilliSec/1000");
    t->SetAlias("runfinT", "MRawRunHeader.fRunStop.fTime.fMilliSec/1000");

    TH1I* hrun = new TH1I("hrun","",finRun-iniRun+1,iniRun,finRun+1);
    TH1I* hent = new TH1I("hent","",finRun-iniRun+1,iniRun,finRun+1);
	
    const char varcut[512];
    const char runcut[512];
    sprintf(runcut,"(run>=%d && run<=%d)",iniRun,finRun);
    sprintf(varcut,"%s*(runfinT-runiniT)",runcut);

    t->Draw("run>>hrun",runcut);
    t->Draw("run>>hent",varcut);

    Float_t seconds=0;
    for(Int_t irun = 1; irun<=finRun-iniRun+1; irun++)
      {
	Int_t nev;
	if(nev=hrun->GetBinContent(irun))
	  {
	    Float_t time = hent->GetBinContent(irun)/nev;
	    seconds += time;	    
	    cout << "run " << iniRun-1+irun << ", " << time <<  " seconds" << endl;
	  }
      }
    
    cout << "Total observation time = " << seconds << " seconds = " << seconds/60. << " minutes = " << seconds/3600. << " hours" << endl;
    delete hrun;
    delete hent;
}


