/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 08/2004 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// This macro is used to read the central control runbook files from
// the data center and store their contents in the runbook-database.
//
// Usage: root readrbk.C("/data/MAGIC/Period014")
//
// This command will loop over all subdirectories, read all *.rbk files and
// store its contents in the database (if an entry with the same date is
// already existing it is ignored).
//
// Make sure, that database and password are corretly set in the macro.
//
///////////////////////////////////////////////////////////////////////////

// --------------------------------------------------------------------------
//
// Checks whether an entry for this date is already existing
//
Bool_t ExistStr(TSQLServer *serv, const char *column, const char *table, const char *test)
{
    TString query(Form("SELECT %s FROM %s WHERE %s='%s'", column, table, column, test));
    TSQLResult *res = serv->Query(query);
    if (!res)
        return kFALSE;

    TSQLRow *row;

    TList rows;
    while (row=res->Next())
    {
        if ((*row)[0])
            return kTRUE;
    }

    return kFALSE;
}

// --------------------------------------------------------------------------
//
// insert the entries from this runbook file into the database
//
void insert(TString fname)
{
    //cout << endl;
    //cout << "FILE: " << fname << endl;

    ifstream fin(fname);
    if (!fin)
    {
        cout << "Could not open file " << fname << endl;
        return;
    }

    TSQLServer *serv = TSQLServer::Connect("mysql://localhost:3306", "hercules", "d99swMT!");
    if (!serv)
    {
        cout << "Could not connect so mysqld..." << endl;
        return;
    }

    TRegexp regexp("^.20[0-9][0-9]-[0-1][0-9]-[0-3][0-9] [0-2][0-9]:[0-5][0-9]:[0-5][0-9].$", kFALSE);

    Int_t num=0;

    Bool_t valid = kFALSE;
    TString entry;
    while (1)
    {
        TString line;
        line.ReadLine(fin);
        if (!fin)
            break;

        TString l0 = line(regexp);

        if (l0.IsNull())
        {
            entry += line;
            entry += "\n";
            continue;
        }
        if (!valid)
        {
            valid = kTRUE;
            entry = "";
            //cout << "First entry skipped..." << endl;
            continue;
        }

        if (entry.Contains("Operator names: "))
        {
            //cout << "OPERATORS: " << entry << flush;
            entry="";
            continue;
        }

        if (entry.Contains("CALIBRATION RUN STATISTICS") ||
            entry.Contains("DATA RUN STATISTICS")        ||
            entry.Contains("PEDESTAL RUN STATISTICS"))
        {
            //cout << "Run entry skipped..." << endl;
            entry ="";
            continue;
        }

        TString date(l0(1, l0.Length()-2));

        if (ExistStr(serv, "fRunBookDate", "MyMagic.RunBook", date))
        {
            entry ="";
            continue;
        }

        entry.ReplaceAll("'", "\\'");
        entry.ReplaceAll("\"", "\\\"");

        TString query("INSERT MyMagic.RunBook (fRunBookDate, fRunBookText) VALUES (\"");
        query += date;
        query += "\", \"";
        query += entry;
        query += "\");";

        if (!serv->Query(query))
            cout << "ERROR: " << query << endl << endl;
        else
            num++;

        entry = "";
    }

    serv->Close();
    delete serv;

    cout << fname << " <" << num << ">" << endl;
}

// --------------------------------------------------------------------------
//
// loop over all files in this path
//
void readrbk(TString path="/data/MAGIC/Period014")
{
    MDirIter Next(path, "*.rbk", -1);

    while (1)
    {
        TString name = Next();
        if (name.IsNull())
            break;
        insert(name);
    }
}
