/********************************************************************\

  SlowData.cc

  Class handling the writing of slow data. String to be written in the
  slow data file are checked that they do not contain control characters.
    
  Oliver Grimm

\********************************************************************/

#include "SlowData.h"
#include "DAQReadout.h"

//
// Constructor: Open slow data file (filename generate using current date)
//
SlowData::SlowData(DAQReadout* DAQClass, const char* IssuerName, char* Direcory) {

  time_t rawtime;
  struct tm *timeinfo;
  char Filename[MAX_PATH];

  m = DAQClass;
  Issuer = IssuerName;
  NewEntryCalled = false;
  InternalCall = false;
  
  time(&rawtime);   timeinfo = localtime(&rawtime);
  snprintf(Filename,sizeof(Filename),"%s/%s_%d%02d%02d.slow",Direcory,Issuer,timeinfo->tm_year+1900,timeinfo->tm_mon+1,timeinfo->tm_mday);

  if ((SlowdataFile = fopen(Filename, "a")) == NULL)
    m->PrintMessage("Warning: Could not open slowdata file '%s' (%s)\n", Filename, strerror(errno));
}

//
// Destructor
//
SlowData::~SlowData() {
  if(SlowdataFile!=NULL && fclose(SlowdataFile)==-1)
    m->PrintMessage("SlowData: Error, could not close slowdata file (%s)\n", strerror(errno));  
}

//
// Add a new entry to slow data file
//
bool SlowData::NewEntry(char *Variable) {

  time_t RawTime;
  struct tm *TM;
  struct timeval Time;

  time(&RawTime);
  TM = localtime(&RawTime);
  gettimeofday(&Time, NULL);
  InternalCall = true;
  NewEntryCalled = AddToEntry("\n%s-%s %lu %lu %d-%d-%dT%d:%d:%d ", Issuer, Variable, Time.tv_sec, Time.tv_usec, TM->tm_year+1900,TM->tm_mon+1,TM->tm_mday,TM->tm_hour,TM->tm_min,TM->tm_sec);
  InternalCall = false;
  return NewEntryCalled;
}

//
// Add data to an open entry
//
bool SlowData::AddToEntry(char *Format, ...) {

  char Textbuffer[MAX_COM_SIZE];
  va_list ArgumentPointer;

  if(SlowdataFile==NULL || (!NewEntryCalled && !InternalCall)) return false;  

  va_start(ArgumentPointer, Format); 
  vsnprintf(Textbuffer, sizeof(Textbuffer), Format, ArgumentPointer);
  va_end(ArgumentPointer);

  if(!InternalCall)
    for(unsigned int i=0; i<strlen(Textbuffer); i++)
      if (iscntrl(Textbuffer[i])) return false;

  if(fprintf(SlowdataFile, "%s", Textbuffer) == -1) {
    m->PrintMessage("SlowData: Error, could not write data to file (%s); closing file\n", strerror(errno));
    fclose(SlowdataFile);
    SlowdataFile = NULL;  
    return false;
  }
  fflush(SlowdataFile);
  return true;
}
