#include <fstream>

#include "MIslands.h"

#include "MCerPhotPix.h"
#include "MCerPhotEvt.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MIslands);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor.
//
MIslands::MIslands(const char *name, const char *title)
{
    fName  = name  ? name  : "MIslands";
    fTitle = title ? title : "Storage container for the island information of one event";
    
}

// --------------------------------------------------------------------------
//
// Destructor.
//
MIslands::~MIslands()
{
  delete fPixNum;
  delete fSigToNoise;
  delete fTimeSpread;
  delete fMeanX;
  delete fMeanY;
  delete fDist;
  delete fDistL;
  delete fDistW;
}


// --------------------------------------------------------------------------
//
// Getter functions
//


// --------------------------------------------------------------------------
//
// Setter functions
//




// --------------------------------------------------------------------------
//
// Print the island parameters to *fLog
//
void MIslands::Print(Option_t *opt) const
{
    *fLog << all;
    *fLog << "Island Parameters (" << GetName() << ")"  << endl;
    *fLog << " - Island Number   = " << fIslNum << endl;
    for (Int_t i = 0; i< fIslNum ; i++)
      {
	*fLog << "   Island Id " << i  << endl;
    	*fLog << "    + Pixel Number = " << fPixNum[i] << endl;
    	*fLog << "    + SigToNoise = " << fSigToNoise[i] << endl;
    	*fLog << "    + TimeSpread   [time slices]= " << fTimeSpread[i] << endl;
    	*fLog << "    + MeanX   [mm]= " << fMeanX[i] << endl;
    	*fLog << "    + MeanY   [mm]= " << fMeanY[i] << endl;
    	*fLog << "    + Dist    [mm]= " << fDist[i] << endl;
    	*fLog << "    + Length of the larger island  [mm]  = "  << fLength <<endl;
	*fLog << "    + Width of the larger island  [mm]  = "  << fWidth <<endl;
	*fLog << "    + DistL  = "  << fDistL[i] <<endl;
    	*fLog << "    + DistW  = " << fDistW[i]  << endl;
      }
}


